/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.process;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.activity.mediation.data.publisher.data.MessageActivity;
import org.wso2.carbon.bam.activity.mediation.data.publisher.publish.ActivityProcessor;
import org.wso2.carbon.bam.service.Event;

public class ActivityWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ActivityWorker.class);
    private Queue<MessageActivity> activityQueue;
    ActivityProcessor activityProcessor;

    public ActivityWorker(Queue<MessageActivity> activityQueue, ActivityProcessor activityProcessor) {
        this.activityQueue = activityQueue;
        this.activityProcessor = activityProcessor;
    }

    @Override
    public void run() {
        this.clearActivityDataQueue(this.activityQueue.size());
    }

    private void clearActivityDataQueue(int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing " + size + " activities from the activity queue..."));
        }
        ArrayList<Event> eventList = new ArrayList<Event>();
        int tenantId = -1;
        for (int i = 0; i < size; ++i) {
            MessageActivity msgActivity = this.activityQueue.poll();
            if (msgActivity == null) continue;
            Event event = this.makeEventObject(msgActivity);
            eventList.add(event);
            tenantId = msgActivity.getTenantId();
        }
        if (eventList.size() > 0) {
            this.activityProcessor.process(eventList, tenantId);
        }
    }

    private Event makeEventObject(MessageActivity msgActivity) {
        HashMap<String, ByteBuffer> correlationData = new HashMap<String, ByteBuffer>();
        HashMap<String, ByteBuffer> metaData = new HashMap<String, ByteBuffer>();
        HashMap<String, ByteBuffer> eventData = new HashMap<String, ByteBuffer>();
        this.addEventData(eventData, msgActivity);
        this.addMetaData(metaData, msgActivity);
        this.addCorrelationData(correlationData, msgActivity);
        Event event = new Event();
        event.setCorrelation(correlationData);
        event.setMeta(metaData);
        event.setEvent(eventData);
        return event;
    }

    private void addCorrelationData(Map<String, ByteBuffer> correlationData, MessageActivity msgActivity) {
        this.putDataIntoMap(correlationData, "bam_activity_id", msgActivity.getActivityId());
    }

    private void addMetaData(Map<String, ByteBuffer> metaData, MessageActivity msgActivity) {
        this.putDataIntoMap(metaData, "sender_host", msgActivity.getSenderHost());
    }

    private void addEventData(Map<String, ByteBuffer> eventData, MessageActivity msgActivity) {
        this.putDataIntoMap(eventData, "service_name", msgActivity.getService());
        this.putDataIntoMap(eventData, "operation_name", msgActivity.getOperation());
        this.putDataIntoMap(eventData, "timestamp", msgActivity.getTimestamp().toString());
        this.putDataIntoMap(eventData, "message_direction", msgActivity.getDirection());
        this.putDataIntoMap(eventData, "message_id", msgActivity.getMessageId());
        this.putDataIntoMap(eventData, "message_body", msgActivity.getPayload());
        this.putDataIntoMap(eventData, "soap_envelop_namespace", msgActivity.getSoapEnvelopNamespaceURI());
        Map<String, String> properties = msgActivity.getProperty();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.putDataIntoMap(eventData, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private void putDataIntoMap(Map<String, ByteBuffer> data, String key, String value) {
        if (value != null) {
            data.put(key, ByteBuffer.wrap(value.getBytes()));
        }
    }
}

