/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.mediator;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.carbon.bam.activity.mediation.data.publisher.conf.ActivityConfigData;
import org.wso2.carbon.bam.activity.mediation.data.publisher.util.ActivityPublisherUtils;
import org.wso2.carbon.bam.activity.mediation.data.publisher.util.TenantActivityConfigData;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class MessageActivityMediator
extends AbstractMediator {
    private boolean extractSoapBody = false;

    public boolean mediate(org.apache.synapse.MessageContext synCtx) {
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        AxisService service = msgCtx.getAxisService();
        if (service == null || service.getParameter("adminService") != null || service.getParameter("hiddenService") != null) {
            return true;
        }
        AxisConfiguration axisConfiguration = msgCtx.getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        Map<Integer, ActivityConfigData> tenantSpecificActivity = TenantActivityConfigData.getTenantSpecificEventingConfigData();
        ActivityConfigData activityConfigData = tenantSpecificActivity.get(tenantID);
        if (activityConfigData.isMessageDumpingEnable()) {
            long currentTime = System.currentTimeMillis();
            this.setActivityIdInSOAPHeader(synCtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing new message through the BAM activity mediator - Message ID=" + synCtx.getMessageID()));
            }
            if (!synCtx.isResponse() && !synCtx.isFaultResponse()) {
                ActivityPublisherUtils.publishEvent(synCtx, currentTime, this.extractSoapBody, true);
            } else {
                ActivityPublisherUtils.publishEvent(synCtx, currentTime, this.extractSoapBody, false);
            }
        }
        return true;
    }

    private void setActivityIdInSOAPHeader(org.apache.synapse.MessageContext synapseContext) {
        try {
            UUID uuid = UUID.randomUUID();
            String uuid_string = uuid.toString();
            Axis2MessageContext axis2smc = (Axis2MessageContext)synapseContext;
            MessageContext axis2MessageContext = axis2smc.getAxis2MessageContext();
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
            SOAPEnvelope soapEnvelope = axis2MessageContext.getEnvelope();
            String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
            SOAPFactory soapFactory = null;
            SOAPHeaderBlock soapHeaderBlock = null;
            if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                soapFactory = OMAbstractFactory.getSOAP11Factory();
            } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
                soapFactory = OMAbstractFactory.getSOAP12Factory();
            } else {
                this.log.error((Object)"Not a standard soap message");
            }
            if (soapEnvelope.getHeader() != null) {
                Iterator itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
                if (!itr.hasNext()) {
                    soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    if (synapseContext.getProperty("bam_activity_id") == null) {
                        soapHeaderBlock.addAttribute("activityID", uuid_string, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuid_string);
                    } else {
                        soapHeaderBlock.addAttribute("activityID", (String)synapseContext.getProperty("bam_activity_id"), null);
                    }
                } else {
                    OMElement bamHeader = (OMElement)itr.next();
                    OMAttribute activityIdAttr = bamHeader.getAttribute(new QName("activityID"));
                    if (activityIdAttr != null) {
                        String activityId = activityIdAttr.getAttributeValue();
                        synapseContext.setProperty("bam_activity_id", (Object)activityId);
                    } else {
                        bamHeader.addAttribute("activityID", uuid_string, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuid_string);
                    }
                }
            } else {
                if (soapFactory != null) {
                    soapFactory.createSOAPHeader(soapEnvelope);
                }
                if (soapEnvelope.getHeader() != null) {
                    soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    if (synapseContext.getProperty("bam_activity_id") == null) {
                        soapHeaderBlock.addAttribute("activityID", uuid_string, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuid_string);
                    } else {
                        soapHeaderBlock.addAttribute("activityID", (String)synapseContext.getProperty("bam_activity_id"), null);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while processing MessageHeaderMediator...", (Throwable)e);
        }
    }

    public void setExtractSoapBody(boolean extractSoapBody) {
        this.extractSoapBody = extractSoapBody;
    }
}

