/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.activity.mediation.data.publisher.conf.RegistryPersistenceManager;
import org.wso2.carbon.bam.activity.mediation.data.publisher.publish.DataPublisher;
import org.wso2.carbon.bam.activity.mediation.data.publisher.queue.ActivityQueue;
import org.wso2.carbon.bam.activity.mediation.data.publisher.util.ActivityPublisherUtils;
import org.wso2.carbon.bam.data.publisher.util.PublisherConfiguration;
import org.wso2.carbon.bam.data.publisher.util.PublisherUtil;
import org.wso2.carbon.bam.data.publisher.util.stats.StatsPrinterTimerTask;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mediation.statistics.services.MediationStatisticsService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ActivityMediatorServiceComponent {
    private static Log log = LogFactory.getLog(ActivityMediatorServiceComponent.class);
    private ActivityQueue activityQueue;
    private MediationStatisticsService statService;

    protected void activate(ComponentContext context) {
        PublisherConfiguration configuration = PublisherUtil.readConfigurationFromAgentConfig();
        ActivityPublisherUtils.setPublisherConfiguration(configuration);
        DataPublisher activityProcessor = new DataPublisher();
        this.activityQueue = new ActivityQueue(activityProcessor, configuration);
        ActivityPublisherUtils.setActivityQueue(this.activityQueue);
        new Thread((Runnable)new StatsPrinterTimerTask()).start();
        new RegistryPersistenceManager().load();
        log.info((Object)"BAM activity mediator bundle is activated");
    }

    protected void setServerConfiguration(ServerConfiguration serverConfiguration) {
        ActivityPublisherUtils.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfiguration serverConfiguration) {
        ActivityPublisherUtils.setServerConfiguration(null);
    }

    protected void setMediationStatisticsService(MediationStatisticsService statService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation statistics service bound to the BAM mediation statistics component");
        }
        this.statService = statService;
    }

    protected void unsetMediationStatisticsService(MediationStatisticsService statService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation statistics service unbound from the BAM mediation statistics component");
        }
        this.statService = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ActivityPublisherUtils.setConfigurationContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        ActivityPublisherUtils.setConfigurationContextService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            RegistryPersistenceManager.setRegistryService(registryService);
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryPersistenceManager.setRegistryService(null);
    }
}

