/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.conf;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.activity.mediation.data.publisher.conf.ActivityConfigData;
import org.wso2.carbon.bam.activity.mediation.data.publisher.util.TenantActivityConfigData;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryPersistenceManager {
    private static final Log log = LogFactory.getLog(RegistryPersistenceManager.class);
    private static RegistryService registryService;
    private static final String EMPTY_STRING = "";

    public static void setRegistryService(RegistryService registryServiceParam) {
        registryService = registryServiceParam;
    }

    public void updateConfigurationProperty(String propertyName, Object value) throws RegistryException {
        String resourcePath = "/repository/components/org.wso2.carbon.bam.activity.mediation.data.publisher/activity/" + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        if (registry != null) {
            if (!registry.resourceExists(resourcePath)) {
                Resource resource = registry.newResource();
                resource.addProperty(propertyName, value.toString());
                registry.put(resourcePath, resource);
            } else {
                Resource resource = registry.get(resourcePath);
                resource.setProperty(propertyName, value.toString());
                registry.put(resourcePath, resource);
            }
        }
    }

    public ActivityConfigData load() {
        ActivityConfigData activityConfigData = new ActivityConfigData();
        activityConfigData.setMessageDumpingEnable(false);
        activityConfigData.setUrl(EMPTY_STRING);
        activityConfigData.setUserName(EMPTY_STRING);
        activityConfigData.setPassword(EMPTY_STRING);
        activityConfigData.setHttpTransportEnable(false);
        activityConfigData.setSocketTransportEnable(true);
        activityConfigData.setPort(7611);
        try {
            String activityEnable = this.getConfigurationProperty("EnableActivity");
            String bamUrl = this.getConfigurationProperty("BAMUrl");
            String bamPassword = this.getConfigurationProperty("BAMPassword");
            String bamUserName = this.getConfigurationProperty("BAMUserName");
            String httpTransportEnable = this.getConfigurationProperty("EnableHttp");
            String socketTransportEnable = this.getConfigurationProperty("EnableSocket");
            String port = this.getConfigurationProperty("port");
            if (activityEnable != null && bamUrl != null && bamPassword != null && bamUserName != null) {
                activityConfigData.setMessageDumpingEnable(Boolean.parseBoolean(activityEnable));
                activityConfigData.setUrl(bamUrl);
                activityConfigData.setUserName(bamUserName);
                activityConfigData.setPassword(bamPassword);
                activityConfigData.setHttpTransportEnable(Boolean.parseBoolean(httpTransportEnable));
                activityConfigData.setSocketTransportEnable(Boolean.parseBoolean(socketTransportEnable));
                if (port != null) {
                    activityConfigData.setPort(Integer.parseInt(port));
                }
                int tenantId = CarbonContext.getCurrentContext().getTenantId();
                Map<Integer, ActivityConfigData> tenantEventConfigData = TenantActivityConfigData.getTenantSpecificEventingConfigData();
                tenantEventConfigData.put(tenantId, activityConfigData);
            } else {
                this.update(activityConfigData);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not load properties from registry", (Throwable)e);
        }
        return activityConfigData;
    }

    public String getConfigurationProperty(String propertyName) throws RegistryException {
        String resourcePath = "/repository/components/org.wso2.carbon.bam.activity.mediation.data.publisher/activity/" + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        String value = null;
        if (registry != null) {
            try {
                if (registry.resourceExists(resourcePath)) {
                    Resource resource = registry.get(resourcePath);
                    value = resource.getProperty(propertyName);
                }
            }
            catch (Exception e) {
                throw new RegistryException("Error while accessing registry", (Throwable)e);
            }
        }
        return value;
    }

    public void update(ActivityConfigData eventingConfigData) throws RegistryException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        Map<Integer, ActivityConfigData> tenantEventConfigData = TenantActivityConfigData.getTenantSpecificEventingConfigData();
        tenantEventConfigData.put(tenantId, eventingConfigData);
        this.updateConfigurationProperty("EnableActivity", eventingConfigData.isMessageDumpingEnable());
        this.updateConfigurationProperty("BAMUrl", eventingConfigData.getUrl());
        this.updateConfigurationProperty("BAMUserName", eventingConfigData.getUserName());
        this.updateConfigurationProperty("BAMPassword", eventingConfigData.getPassword());
        this.updateConfigurationProperty("EnableHttp", eventingConfigData.isHttpTransportEnable());
        this.updateConfigurationProperty("EnableSocket", eventingConfigData.isSocketTransportEnable());
        this.updateConfigurationProperty("port", eventingConfigData.getPort());
    }

    public ActivityConfigData getEventingConfigData() {
        return this.load();
    }
}

