/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.autoscaler.service.exception.MalformedConfigurationFileException;
import org.wso2.carbon.autoscaler.service.util.IaaSProvider;
import org.wso2.carbon.autoscaler.service.util.ServiceTemplate;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class AutoscalerConfigFileReader {
    private static final Log log = LogFactory.getLog(AutoscalerConfigFileReader.class);
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Document dom;
    private Element docEle;
    private String autoscalerConfigXMLFile;
    private static final String EC2_IDENTITY_ALIAS = "autoscaler.ec2.identity";
    private static final String EC2_CREDENTIAL_ALIAS = "autoscaler.ec2.credential";
    private static final String OPENSTACK_IDENTITY_ALIAS = "autoscaler.openstack.identity";
    private static final String OPENSTACK_CREDENTIAL_ALIAS = "autoscaler.openstack.credential";

    public AutoscalerConfigFileReader() {
        this.autoscalerConfigXMLFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "autoscaler-config.xml";
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            this.dom = db.parse(this.autoscalerConfigXMLFile);
        }
        catch (Exception ex) {
            String msg = "Error occurred while parsing the " + this.autoscalerConfigXMLFile + ".";
            log.error((Object)msg, (Throwable)ex);
            throw new MalformedConfigurationFileException(msg, ex);
        }
    }

    public AutoscalerConfigFileReader(String file) {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            this.dom = db.parse(file);
        }
        catch (Exception ex) {
            String msg = "Error occurred when parsing the " + file + ".";
            log.error((Object)msg, (Throwable)ex);
            throw new MalformedConfigurationFileException(msg, ex);
        }
    }

    public List<IaaSProvider> getIaasProvidersList() {
        ArrayList<IaaSProvider> iaasProviders = new ArrayList<IaaSProvider>();
        this.docEle = this.dom.getDocumentElement();
        NodeList nl = this.docEle.getElementsByTagName("iaasProvider");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                iaasProviders.add(this.getIaasProvider(nl.item(i)));
            }
        } else {
            String msg = "Essential 'iaasProvider' element cannot be found in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
        return iaasProviders;
    }

    private IaaSProvider getIaasProvider(Node item) {
        IaaSProvider iaas = new IaaSProvider();
        if (item.getNodeType() == 1) {
            Element iaasElt = (Element)item;
            iaas.setName(iaasElt.getAttribute("name"));
            if ("".equals(iaas.getName())) {
                String msg = "'iaasProvider' element's 'name' attribute should be specified!";
                log.error((Object)msg);
                throw new MalformedConfigurationFileException(msg);
            }
            iaas.setProperties(this.loadProperties(iaasElt));
            this.loadTemplate(iaas, iaasElt);
            this.loadScalingOrders(iaas, iaasElt);
            this.loadProvider(iaas, iaasElt);
            this.loadIdentity(iaas, iaasElt);
            this.loadCredentials(iaas, iaasElt);
        }
        return iaas;
    }

    public List<ServiceTemplate> getTemplates() {
        Node item;
        ArrayList<ServiceTemplate> templates = new ArrayList<ServiceTemplate>();
        ServiceTemplate template = new ServiceTemplate();
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("default");
        if (nl != null && nl.getLength() > 0 && (item = nl.item(0)).getNodeType() == 1) {
            Element defaultElt = (Element)item;
            template.setProperties(this.loadProperties(defaultElt));
        }
        if ((nl = docEle.getElementsByTagName("service")) != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item2 = nl.item(i);
                try {
                    ServiceTemplate temp = (ServiceTemplate)template.clone();
                    if (item2.getNodeType() == 1) {
                        Element imageElt = (Element)item2;
                        if ("".equals(imageElt.getAttribute("domain"))) {
                            String msg = "Essential 'domain' attribute of 'image' element cannot be found in " + this.autoscalerConfigXMLFile;
                            log.error((Object)msg);
                            throw new MalformedConfigurationFileException(msg);
                        }
                        temp.setDomainName(imageElt.getAttribute("domain"));
                        Map<String, String> customProperties = this.loadProperties(imageElt);
                        for (Map.Entry<String, String> pair : customProperties.entrySet()) {
                            temp.setProperty(pair.getKey(), pair.getValue());
                        }
                    }
                    templates.add(temp);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    String msg = "This is extraordinary!! ";
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
        }
        return templates;
    }

    public Map<String, String> getDomainToTemplateMap() {
        Element imageElt;
        Node item;
        HashMap<String, String> domainToTemplateMap = new HashMap<String, String>();
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("image");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element imageElt2;
                Node item2 = nl.item(i);
                if (item2.getNodeType() != 1 || "".equals((imageElt2 = (Element)item2).getAttribute("domain"))) continue;
                domainToTemplateMap.put(imageElt2.getAttribute("domain"), imageElt2.getAttribute("payload"));
            }
        }
        if ((nl = docEle.getElementsByTagName("default")) != null && nl.getLength() > 0 && (item = nl.item(0)).getNodeType() == 1 && !"".equals((imageElt = (Element)item).getAttribute("payload"))) {
            domainToTemplateMap.put("*", imageElt.getAttribute("payload"));
        }
        if (domainToTemplateMap.size() == 0) {
            String msg = "Essential 'images' element cannot be found in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
        return domainToTemplateMap;
    }

    private void loadCredentials(IaaSProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("credential");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.autoscalerConfigXMLFile + " contains more than one credential elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                SecretResolver secretResolver = SecretResolverFactory.create((Element)this.docEle, (boolean)false);
                String alias = iaas.getProvider().contains("ec2") ? EC2_CREDENTIAL_ALIAS : OPENSTACK_CREDENTIAL_ALIAS;
                if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(alias)) {
                    log.info((Object)("****** " + secretResolver.resolve(alias) + " |||| " + alias));
                    iaas.setCredential(secretResolver.resolve(alias));
                }
            }
        } else {
            String msg = "Essential 'credential' element has not specified in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
    }

    private void loadIdentity(IaaSProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("identity");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.autoscalerConfigXMLFile + " contains more than one identity elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                SecretResolver secretResolver = SecretResolverFactory.create((Element)this.docEle, (boolean)false);
                String alias = iaas.getProvider().contains("ec2") ? EC2_IDENTITY_ALIAS : OPENSTACK_IDENTITY_ALIAS;
                if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(alias)) {
                    iaas.setIdentity(secretResolver.resolve(alias));
                }
            }
        } else {
            String msg = "Essential 'identity' element has not specified in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
    }

    private void loadProvider(IaaSProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("provider");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.autoscalerConfigXMLFile + " contains more than one provider elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                Element prop = (Element)nl.item(0);
                iaas.setProvider(prop.getTextContent());
            }
        } else {
            String msg = "Essential 'provider' element has not specified in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
    }

    private void loadScalingOrders(IaaSProvider iaas, Element iaasElt) {
        Element prop;
        NodeList nl = iaasElt.getElementsByTagName("scaleUpOrder");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.autoscalerConfigXMLFile + " contains more than one scaleUpOrder elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                prop = (Element)nl.item(0);
                try {
                    iaas.setScaleUpOrder(Integer.parseInt(prop.getTextContent()));
                }
                catch (NumberFormatException e) {
                    String msg = "scaleUpOrder element contained in " + this.autoscalerConfigXMLFile + "" + " has a value which is not an Integer value.";
                    log.error((Object)msg, (Throwable)e);
                    throw new MalformedConfigurationFileException(msg, e);
                }
            }
        } else {
            String msg = "Essential 'scaleUpOrder' element has not specified in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
        if ((nl = iaasElt.getElementsByTagName("scaleDownOrder")) != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.autoscalerConfigXMLFile + " contains more than one scaleDownOrder elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                prop = (Element)nl.item(0);
                try {
                    iaas.setScaleDownOrder(Integer.parseInt(prop.getTextContent()));
                }
                catch (NumberFormatException e) {
                    String msg = "scaleDownOrder element contained in " + this.autoscalerConfigXMLFile + "" + " has a value which is not an Integer value.";
                    log.error((Object)msg, (Throwable)e);
                    throw new MalformedConfigurationFileException(msg, e);
                }
            }
        } else {
            String msg = "Essential 'scaleDownOrder' element has not specified in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
    }

    private void loadTemplate(IaaSProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("template");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.autoscalerConfigXMLFile + " contains more than one template elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                Element prop = (Element)nl.item(0);
                iaas.setTemplate(prop.getTextContent());
            }
        } else {
            String msg = "Essential 'template' element has not specified in " + this.autoscalerConfigXMLFile;
            log.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
    }

    private Map<String, String> loadProperties(Element iaasElt) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        NodeList nl = iaasElt.getElementsByTagName("property");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element prop = (Element)nl.item(i);
                if ("".equals(prop.getAttribute("name")) || "".equals(prop.getAttribute("value"))) {
                    String msg = "Property element's, name and value attributes should be specified in " + this.autoscalerConfigXMLFile;
                    log.error((Object)msg);
                    throw new MalformedConfigurationFileException(msg);
                }
                propertyMap.put(prop.getAttribute("name"), prop.getAttribute("value"));
            }
        }
        return propertyMap;
    }
}

