/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.wso2.carbon.autoscaler.service.IAutoscalerService;
import org.wso2.carbon.autoscaler.service.jcloud.ComputeServiceBuilder;
import org.wso2.carbon.autoscaler.service.util.IaaSProvider;
import org.wso2.carbon.autoscaler.service.util.IaaSProviderComparator;
import org.wso2.carbon.autoscaler.service.util.ServiceTemplate;
import org.wso2.carbon.autoscaler.service.xml.AutoscalerConfigFileReader;
import org.wso2.carbon.lb.common.persistence.AgentPersistenceManager;
import org.wso2.carbon.utils.CarbonUtils;

public class AutoscalerServiceImpl
implements IAutoscalerService {
    AgentPersistenceManager agentPersistenceManager = AgentPersistenceManager.getPersistenceManager();
    private static final Log log = LogFactory.getLog(AutoscalerServiceImpl.class);
    private String carbonHome = CarbonUtils.getCarbonHome();
    private List<IaaSProvider> iaasProviders;
    private List<ServiceTemplate> temps;
    private List<Enum<iaases>> scaleUpOrder = new ArrayList<Enum<iaases>>();
    private List<Enum<iaases>> scaleDownOrder = new ArrayList<Enum<iaases>>();
    private Map<String, String> nodeIdToDomainMap = new HashMap<String, String>();
    private List<Iaas> iaasEntities = new ArrayList<Iaas>();
    private Map<String, Iaas> domainToLastlyBuiltIaasMap = new HashMap<String, Iaas>();

    @Override
    public boolean initAutoscaler(boolean isSpi) {
        AutoscalerConfigFileReader configReader = new AutoscalerConfigFileReader();
        this.iaasProviders = configReader.getIaasProvidersList();
        this.temps = configReader.getTemplates();
        for (IaaSProvider iaas : this.iaasProviders) {
            Iaas entity;
            ComputeService computeService = ComputeServiceBuilder.buildComputeService(iaas);
            if (iaas.getName().equalsIgnoreCase(iaases.ec2.toString())) {
                entity = new Iaas(iaases.ec2, computeService);
                if (!isSpi) {
                    this.buildEC2Templates(entity, iaas.getTemplate(), isSpi);
                    continue;
                }
                this.iaasEntities.add(entity);
                continue;
            }
            if (iaas.getName().equalsIgnoreCase(iaases.lxc.toString())) {
                entity = new Iaas(iaases.lxc, computeService);
                if (!isSpi) {
                    this.buildLXCTemplates(entity, iaas.getTemplate(), isSpi);
                    continue;
                }
                this.iaasEntities.add(entity);
                continue;
            }
            throw new RuntimeException("Unsupported IaaS! " + iaas.getName());
        }
        this.fillInScaleUpOrder();
        this.fillInScaleDownOrder();
        return true;
    }

    @Override
    public boolean startInstance(String domainName) {
        log.info((Object)("Starting new instance of domain : " + domainName));
        for (Enum<iaases> iaas : this.scaleUpOrder) {
            Iaas iaasTemp = this.findIaas(iaas);
            if (iaasTemp == null) {
                log.warn((Object)("Failed to start an instance in " + iaas + "" + ". Hence, will try to start in another IaaS if available."));
                continue;
            }
            ComputeService computeService = iaasTemp.getComputeService();
            Template template = iaasTemp.getTemplate(domainName);
            String group = domainName.contains(".") ? domainName.replace('.', '-') : domainName;
            try {
                Set nodes = computeService.createNodesInGroup(group, 1, template);
                NodeMetadata node = (NodeMetadata)nodes.iterator().next();
                iaasTemp.addNode(node, domainName);
                this.replaceIaas(iaasTemp);
                this.domainToLastlyBuiltIaasMap.put(domainName, iaasTemp);
                log.info((Object)("*************** getProviderId = " + node.getProviderId()));
                log.info((Object)("*************** getType = " + node.getType().toString()));
            }
            catch (RunNodesException e) {
                log.warn((Object)("Failed to start an instance in " + iaas + "" + ". Hence, will try to start in another IaaS if available."), (Throwable)e);
                continue;
            }
            log.info((Object)"Done.... Started...");
            return true;
        }
        return false;
    }

    @Override
    public String startSpiInstance(String domainName, String imageId) {
        iaases iaas;
        Iaas entry;
        if (imageId.startsWith("nova") && (entry = this.findIaas(iaases.lxc)) != null) {
            iaas = iaases.lxc;
            this.buildLXCTemplates(entry, imageId, true);
        } else {
            entry = this.findIaas(iaases.ec2);
            if (entry != null) {
                iaas = iaases.ec2;
                this.buildEC2Templates(entry, imageId, true);
            } else {
                throw new RuntimeException("Invalid image id!!");
            }
        }
        NodeMetadata node = this.findIaas(iaas).getLastMatchingNode(domainName);
        if (this.startInstance(domainName) && node != null && node.getPublicAddresses().size() > 0) {
            return (String)node.getPublicAddresses().iterator().next();
        }
        return "";
    }

    @Override
    public boolean terminateInstance(String domainName) {
        for (Enum<iaases> iaas : this.scaleDownOrder) {
            String msg = "Failed to terminate an instance in " + iaas.toString() + "" + ". Hence, will try to terminate an instance in another IaaS if possible.";
            Iaas iaasTemp = this.findIaas(iaas);
            if (iaasTemp == null) {
                log.warn((Object)(msg + " : Reason- Iaas' data cannot be located!"));
                continue;
            }
            NodeMetadata node = iaasTemp.getFirstMatchingNode(domainName);
            if (node == null) {
                log.warn((Object)(msg + " : Reason- No matching instance found for domain '" + domainName + "'."));
                continue;
            }
            this.terminate(iaasTemp, node);
            return true;
        }
        return false;
    }

    @Override
    public boolean terminateLastlySpawnedInstance(String domainName) {
        if (this.domainToLastlyBuiltIaasMap.containsKey(domainName)) {
            Iaas iaasTemp = this.domainToLastlyBuiltIaasMap.get(domainName);
            String msg = "Failed to terminate the lastly spawned instance of '" + domainName + "' service domain.";
            if (iaasTemp == null) {
                log.error((Object)(msg + " : Reason- Iaas' data cannot be located!"));
                return false;
            }
            NodeMetadata node = iaasTemp.getLastMatchingNode(domainName);
            if (node == null) {
                log.error((Object)(msg + " : Reason- No matching instance found for domain '" + domainName + "'."));
                return false;
            }
            this.terminate(iaasTemp, node);
            return true;
        }
        return false;
    }

    @Override
    public boolean terminateSpiInstance(String publicIp) {
        for (Enum<iaases> iaas : this.scaleDownOrder) {
            String msg = "Failed to terminate an instance in " + iaas.toString() + "" + ". Hence, will try to terminate an instance in another IaaS if possible.";
            Iaas iaasTemp = this.findIaas(iaas);
            if (iaasTemp == null) {
                log.warn((Object)(msg + " : Reason- Iaas' data cannot be located!"));
                continue;
            }
            NodeMetadata node = iaasTemp.getNodeWithPublicIp(publicIp);
            if (node == null) {
                log.warn((Object)(msg + " : Reason- No matching instance found for public ip '" + publicIp + "'."));
                continue;
            }
            this.terminate(iaasTemp, node);
            return true;
        }
        return false;
    }

    private void terminate(Iaas iaasTemp, NodeMetadata node) {
        String nodeId = node.getId();
        iaasTemp.getComputeService().destroyNode(nodeId);
        iaasTemp.removeNode(node);
        this.replaceIaas(iaasTemp);
        log.info((Object)("******** Terminated! Node Id: " + nodeId));
    }

    @Override
    public int getPendingInstanceCount(String domainName) {
        int pendingInstanceCount = 0;
        for (Iaas entry : this.iaasEntities) {
            ComputeService computeService = entry.getComputeService();
            List<String> nodeIds = entry.getNodeIds(domainName);
            Set set = computeService.listNodes();
            for (NodeMetadataImpl nodeMetadata : set) {
                NodeMetadata.Status nodeStatus;
                if (!nodeIds.contains(nodeMetadata.getId()) || !(nodeStatus = nodeMetadata.getStatus()).toString().equalsIgnoreCase("PENDING")) continue;
                ++pendingInstanceCount;
            }
        }
        log.info((Object)("*********** pending instance count " + pendingInstanceCount));
        return pendingInstanceCount;
    }

    private Iaas findIaas(Enum<iaases> iaas) {
        for (Iaas entry : this.iaasEntities) {
            if (!entry.getName().equals(iaas)) continue;
            return entry;
        }
        return null;
    }

    private void fillInScaleDownOrder() {
        Collections.sort(this.iaasProviders, IaaSProviderComparator.ascending(IaaSProviderComparator.getComparator(IaaSProviderComparator.SCALE_DOWN_SORT)));
        for (IaaSProvider iaas : this.iaasProviders) {
            this.scaleDownOrder.add(iaases.valueOf(iaas.getName()));
        }
    }

    private void fillInScaleUpOrder() {
        Collections.sort(this.iaasProviders, IaaSProviderComparator.ascending(IaaSProviderComparator.getComparator(IaaSProviderComparator.SCALE_UP_SORT)));
        for (IaaSProvider iaas : this.iaasProviders) {
            this.scaleUpOrder.add(iaases.valueOf(iaas.getName()));
        }
    }

    public byte[] getUserData(String payloadFileName) {
        byte[] bytes = null;
        try {
            File file = new File(payloadFileName);
            if (!file.exists()) {
                this.handleException("Payload file " + payloadFileName + " does not exist");
            }
            if (!file.canRead()) {
                this.handleException("Payload file " + payloadFileName + " does cannot be read");
            }
            bytes = this.getBytesFromFile(file);
        }
        catch (IOException e) {
            AutoscalerServiceImpl.handleException("Cannot read data from payload file " + payloadFileName, e);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        if (!file.exists()) {
            log.error((Object)("Payload file " + file.getAbsolutePath() + " does not exist"));
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            int offset;
            int numRead;
            long length = file.length();
            if (length > Integer.MAX_VALUE && log.isDebugEnabled()) {
                log.debug((Object)"File is too large");
            }
            bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }

    public void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void replaceIaas(Iaas replacement) {
        for (Iaas entry : this.iaasEntities) {
            if (!entry.equals(replacement)) continue;
            int idx = this.iaasEntities.indexOf(entry);
            this.iaasEntities.remove(idx);
            this.iaasEntities.add(idx, replacement);
            return;
        }
        this.iaasEntities.add(replacement);
    }

    private void buildLXCTemplates(Iaas entity, String imageId, boolean blockUntilRunning) {
        if (entity.getComputeService() == null) {
            throw new RuntimeException("Compute service is null for IaaS provider: " + entity.getName());
        }
        TemplateBuilder templateBuilder = entity.getComputeService().templateBuilder();
        templateBuilder.imageId(imageId);
        for (ServiceTemplate temp : this.temps) {
            Template template = templateBuilder.build();
            template.getOptions().as(TemplateOptions.class).blockUntilRunning(blockUntilRunning);
            ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).securityGroupNames(temp.getProperty("securityGroups").split(","));
            ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).userData(this.getUserData(this.carbonHome + File.separator + temp.getProperty("payload")));
            ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).keyPairName(temp.getProperty("keyPair"));
            entity.addToDomainToTemplateMap(temp.getDomainName(), template);
        }
        this.replaceIaas(entity);
    }

    private void buildEC2Templates(Iaas entity, String imageId, boolean blockUntilRunning) {
        if (entity.getComputeService() == null) {
            throw new RuntimeException("Compute service is null for IaaS provider: " + entity.getName());
        }
        TemplateBuilder templateBuilder = entity.getComputeService().templateBuilder();
        templateBuilder.imageId(imageId);
        for (ServiceTemplate temp : this.temps) {
            templateBuilder.hardwareId(temp.getProperty("instanceType"));
            Template template = templateBuilder.build();
            template.getOptions().as(TemplateOptions.class).blockUntilRunning(blockUntilRunning);
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).placementGroup(temp.getProperty("availabilityZone"));
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).securityGroups(temp.getProperty("securityGroups").split(","));
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).userData(this.getUserData(this.carbonHome + File.separator + temp.getProperty("payload")));
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).keyPair(temp.getProperty("keyPair"));
            entity.addToDomainToTemplateMap(temp.getDomainName(), template);
        }
        this.replaceIaas(entity);
    }

    private class Iaas {
        private Enum<iaases> name;
        Map<String, Template> domainToTemplateMap = new HashMap<String, Template>();
        ComputeService computeService;
        Map<NodeMetadata, String> nodeToDomainMap = new LinkedHashMap<NodeMetadata, String>();

        public Iaas(Enum<iaases> name, ComputeService computeService) {
            this.name = name;
            this.computeService = computeService;
        }

        public Enum<iaases> getName() {
            return this.name;
        }

        public void addToDomainToTemplateMap(String key, Template value) {
            this.domainToTemplateMap.put(key, value);
        }

        public Template getTemplate(String key) {
            return this.domainToTemplateMap.get(key);
        }

        public ComputeService getComputeService() {
            return this.computeService;
        }

        public void addNode(NodeMetadata node, String domain) {
            this.nodeToDomainMap.put(node, domain);
        }

        public NodeMetadata getLastMatchingNode(String domain) {
            ListIterator<Map.Entry<NodeMetadata, String>> iter = new ArrayList<Map.Entry<NodeMetadata, String>>(this.nodeToDomainMap.entrySet()).listIterator(this.nodeToDomainMap.size());
            while (iter.hasPrevious()) {
                Map.Entry<NodeMetadata, String> entry = iter.previous();
                if (!entry.getValue().equals(domain)) continue;
                return entry.getKey();
            }
            return null;
        }

        public NodeMetadata getFirstMatchingNode(String domain) {
            for (Map.Entry<NodeMetadata, String> entry : this.nodeToDomainMap.entrySet()) {
                if (!entry.getValue().equals(domain)) continue;
                return entry.getKey();
            }
            return null;
        }

        public NodeMetadata getNodeWithPublicIp(String publicIp) {
            for (NodeMetadata node : this.nodeToDomainMap.keySet()) {
                if (!((String)node.getPublicAddresses().iterator().next()).equals(publicIp)) continue;
                return node;
            }
            return null;
        }

        public List<String> getNodeIds(String domain) {
            ArrayList<String> nodeIds = new ArrayList<String>();
            for (Map.Entry<NodeMetadata, String> entry : this.nodeToDomainMap.entrySet()) {
                if (!entry.getValue().equals(domain)) continue;
                nodeIds.add(entry.getKey().getId());
            }
            return nodeIds;
        }

        public void removeNode(NodeMetadata node) {
            AutoscalerServiceImpl.this.nodeIdToDomainMap.remove(node);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Iaas) {
                return new EqualsBuilder().append(this.getName(), ((Iaas)obj).getName()).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append(this.name).toHashCode();
        }
    }

    private static enum iaases {
        ec2,
        lxc;

    }
}

