/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.io.OutputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;

public class Suppliers2 {
    public static <K, V> Supplier<V> getLastValueInMap(Supplier<Map<K, Supplier<V>>> input) {
        return Suppliers2.compose(new Function<Map<K, Supplier<V>>, V>(){

            public V apply(Map<K, Supplier<V>> input) {
                return ((Supplier)Iterables.getLast(input.values())).get();
            }

            public String toString() {
                return "getLastValueInMap()";
            }
        }, input);
    }

    public static <X> Function<X, Supplier<X>> ofInstanceFunction() {
        return new Function<X, Supplier<X>>(){

            public Supplier<X> apply(X arg0) {
                return Suppliers.ofInstance(arg0);
            }

            public String toString() {
                return "Suppliers.ofInstance()";
            }
        };
    }

    public static OutputSupplier<OutputStream> newOutputStreamSupplier(final OutputStream output) {
        Preconditions.checkNotNull((Object)output, (Object)"output");
        return new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return output;
            }
        };
    }

    public static <F, T> Supplier<T> compose(Function<? super F, T> function, Supplier<F> supplier) {
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(supplier);
        return new SupplierComposition<F, T>(function, supplier);
    }

    private static class SupplierComposition<F, T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 1023509665531743802L;
        final Function<? super F, T> function;
        final Supplier<F> supplier;

        SupplierComposition(Function<? super F, T> function, Supplier<F> supplier) {
            this.function = function;
            this.supplier = supplier;
        }

        public T get() {
            return (T)this.function.apply(this.supplier.get());
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("function", this.function).add("supplier", this.supplier).toString();
        }
    }
}

