/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class SeedAnnotationCache
extends CacheLoader<Class<?>, Boolean> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Injector injector;

    @Inject
    public SeedAnnotationCache(Injector injector) {
        this.injector = injector;
    }

    public Boolean load(Class<?> declaring) throws ExecutionException {
        for (Method method : Sets.difference((Set)ImmutableSet.copyOf((Object[])declaring.getMethods()), (Set)ImmutableSet.copyOf((Object[])Object.class.getMethods()))) {
            if (SeedAnnotationCache.isHttpMethod(method) || method.isAnnotationPresent(Delegate.class)) {
                for (int index = 0; index < method.getParameterTypes().length; ++index) {
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToBinderParamAnnotation.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToWrapWithAnnotation.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToHeaderParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToMatrixParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToFormParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToQueryParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToEndpointAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToEndpointParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToPathParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToPostParamAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToParamParserAnnotations.get((Object)method)).get((Object)index);
                    ((LoadingCache)RestAnnotationProcessor.methodToIndexOfParamToPartParamAnnotations.get((Object)method)).get((Object)index);
                    RestAnnotationProcessor.methodToIndexesOfOptions.get((Object)method);
                }
                RestAnnotationProcessor.delegationMap.put(new RestAnnotationProcessor.MethodKey(method), method);
                continue;
            }
            if (!method.getDeclaringClass().equals(declaring)) {
                this.logger.trace("skipping potentially overridden method %s", method);
                continue;
            }
            if (method.isAnnotationPresent(Provides.class)) {
                this.logger.trace("skipping provider method %s", method);
                continue;
            }
            this.logger.trace("Method is not annotated as either http or provider method: %s", method);
        }
        return true;
    }

    public static boolean isHttpMethod(Method method) {
        return method.isAnnotationPresent(Path.class) || RestAnnotationProcessor.getHttpMethods(method) != null || ImmutableSet.copyOf((Object[])method.getParameterTypes()).contains(HttpRequest.class);
    }
}

