/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import org.jclouds.internal.ContextImpl;
import org.jclouds.lifecycle.Closer;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.Utils;
import org.jclouds.rest.annotations.Identity;

@Singleton
public class RestContextImpl<S, A>
extends ContextImpl
implements RestContext<S, A> {
    private final A asyncApi;
    private final S syncApi;

    @Inject
    protected RestContextImpl(ProviderMetadata providerMetadata, @Identity String identity, Utils utils, Closer closer, Injector injector, TypeLiteral<S> syncApi, TypeLiteral<A> asyncApi) {
        super(providerMetadata, identity, utils, closer);
        Preconditions.checkNotNull((Object)injector, (Object)"injector");
        this.asyncApi = injector.getInstance(Key.get((TypeLiteral)((TypeLiteral)Preconditions.checkNotNull(asyncApi, (Object)"asyncApi"))));
        this.syncApi = injector.getInstance(Key.get((TypeLiteral)((TypeLiteral)Preconditions.checkNotNull(syncApi, (Object)"syncApi"))));
    }

    @Override
    public A getAsyncApi() {
        return this.asyncApi;
    }

    @Override
    public S getApi() {
        return this.syncApi;
    }
}

