/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindMapToStringPayload
implements MapBinder {
    protected final Provider<UriBuilder> uriBuilders;

    @Inject
    public BindMapToStringPayload(Provider<UriBuilder> uriBuilders) {
        this.uriBuilders = (Provider)Preconditions.checkNotNull(uriBuilders, (Object)"uriBuilders");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkNotNull(postParams, (Object)"postParams");
        GeneratedHttpRequest r = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(Preconditions.checkNotNull(request, (Object)"request"));
        Preconditions.checkArgument((boolean)r.getJavaMethod().isAnnotationPresent(Payload.class), (String)"method %s must have @Payload annotation to use this binder", (Object[])new Object[]{r.getJavaMethod()});
        String payload = r.getJavaMethod().getAnnotation(Payload.class).value();
        if (postParams.size() > 0) {
            UriBuilder builder = (UriBuilder)this.uriBuilders.get();
            builder.uri(URI.create("http://fake/"));
            builder.path(payload);
            URI fake = builder.buildFromMap(postParams);
            payload = fake.getPath().substring(1);
        }
        return (R)request.toBuilder().payload(Payloads.newStringPayload(payload)).build();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        throw new IllegalArgumentException("this is a map binder");
    }
}

