/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.osgi;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class MetadataBundleListener
implements BundleListener {
    private Map<Long, ProviderMetadata> providerMetadataMap = new HashMap<Long, ProviderMetadata>();
    private Map<Long, ApiMetadata> apiMetadataMap = new HashMap<Long, ApiMetadata>();

    public void start(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            ProviderMetadata providerMetadata = this.getProviderMetadata(bundle);
            ApiMetadata apiMetadata = this.getApiMetadata(bundle);
            if (providerMetadata != null) {
                ProviderRegistry.registerProvider(providerMetadata);
                this.providerMetadataMap.put(bundle.getBundleId(), providerMetadata);
            }
            if (apiMetadata == null) continue;
            ApiRegistry.registerApi(apiMetadata);
            this.apiMetadataMap.put(bundle.getBundleId(), apiMetadata);
        }
    }

    public void stop(BundleContext bundleContext) {
        this.providerMetadataMap.clear();
        this.apiMetadataMap.clear();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                ProviderMetadata providerMetadata = this.getProviderMetadata(event.getBundle());
                ApiMetadata apiMetadata = this.getApiMetadata(event.getBundle());
                if (providerMetadata != null) {
                    ProviderRegistry.registerProvider(providerMetadata);
                    this.providerMetadataMap.put(event.getBundle().getBundleId(), providerMetadata);
                }
                if (apiMetadata == null) break;
                ApiRegistry.registerApi(apiMetadata);
                this.apiMetadataMap.put(event.getBundle().getBundleId(), apiMetadata);
                break;
            }
            case 4: 
            case 256: {
                ProviderMetadata providerMetadata = this.providerMetadataMap.get(event.getBundle().getBundleId());
                ApiMetadata apiMetadata = this.apiMetadataMap.get(event.getBundle().getBundleId());
                if (providerMetadata != null) {
                    ProviderRegistry.uRegisterProvider(providerMetadata);
                }
                if (apiMetadata == null) break;
                ApiRegistry.unRegisterApi(apiMetadata);
            }
        }
    }

    public ProviderMetadata getProviderMetadata(Bundle bundle) {
        ProviderMetadata metadata = null;
        String className = this.getProviderMetadataClassName(bundle);
        if (className != null && !className.isEmpty()) {
            try {
                Class providerMetadataClass = bundle.loadClass(className);
                metadata = (ProviderMetadata)providerMetadataClass.newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return metadata;
    }

    public ApiMetadata getApiMetadata(Bundle bundle) {
        ApiMetadata metadata = null;
        String className = this.getApiMetadataClassName(bundle);
        if (className != null && !className.isEmpty()) {
            try {
                Class apiMetadataClass = bundle.loadClass(className);
                metadata = (ApiMetadata)apiMetadataClass.newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadataClassName(Bundle bundle, String pathToMetadata) {
        URL resource = bundle.getEntry(pathToMetadata);
        InputStream is = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            is = resource.openStream();
            reader = new InputStreamReader(is, "UTF-8");
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Throwable e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable e) {}
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        return sb.toString().trim();
    }

    public String getProviderMetadataClassName(Bundle bundle) {
        return this.getMetadataClassName(bundle, "/META-INF/services/org.jclouds.providers.ProviderMetadata");
    }

    public String getApiMetadataClassName(Bundle bundle) {
        return this.getMetadataClassName(bundle, "/META-INF/services/org.jclouds.apis.ApiMetadata");
    }
}

