/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.fromconfig;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.Iso3166;
import org.jclouds.location.suppliers.LocationIdToIso3166CodesSupplier;

@Singleton
public class LocationIdToIso3166CodesFromConfiguration
implements LocationIdToIso3166CodesSupplier {
    private final Function<Predicate<String>, Map<String, String>> filterStringsBoundByName;

    @Inject
    public LocationIdToIso3166CodesFromConfiguration(Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        this.filterStringsBoundByName = (Function)Preconditions.checkNotNull(filterStringsBoundByName, (Object)"filterStringsBoundByName");
    }

    @Singleton
    @Iso3166
    public Map<String, Supplier<Set<String>>> get() {
        Map stringsBoundWithRegionOrZonePrefix = (Map)this.filterStringsBoundByName.apply((Object)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith("jclouds.region") || input.startsWith("jclouds.zone");
            }
        });
        ImmutableMap.Builder codes = ImmutableMap.builder();
        for (String key : ImmutableSet.of((Object)"jclouds.region", (Object)"jclouds.zone")) {
            String regionOrZoneString = (String)stringsBoundWithRegionOrZonePrefix.get(key + "s");
            if (regionOrZoneString == null) continue;
            for (String region : Splitter.on((char)',').split((CharSequence)regionOrZoneString)) {
                String isoCodes = (String)stringsBoundWithRegionOrZonePrefix.get(key + "." + region + "." + "iso3166-codes");
                if (isoCodes == null) continue;
                codes.put((Object)region, (Object)Suppliers.ofInstance((Object)ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)isoCodes))));
            }
        }
        return codes.build();
    }
}

