/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.derived;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;

@Singleton
public class ZoneIdToURIFromJoinOnRegionIdToURI
implements ZoneIdToURISupplier {
    private final Supplier<Map<String, Supplier<URI>>> regionIdToURISupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier;

    @Inject
    protected ZoneIdToURIFromJoinOnRegionIdToURI(@Region Supplier<Map<String, Supplier<URI>>> regionIdToURISupplier, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier) {
        this.regionIdToURISupplier = regionIdToURISupplier;
        this.regionIdToZoneIdsSupplier = regionIdToZoneIdsSupplier;
    }

    public Map<String, Supplier<URI>> get() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry regionToURI : ((Map)this.regionIdToURISupplier.get()).entrySet()) {
            for (String zone : (Set)((Supplier)((Map)this.regionIdToZoneIdsSupplier.get()).get(regionToURI.getKey())).get()) {
                builder.put((Object)zone, regionToURI.getValue());
            }
        }
        return builder.build();
    }
}

