/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jclouds.io.payloads.BasePayload;

public class ByteArrayPayload
extends BasePayload<byte[]> {
    public ByteArrayPayload(byte[] content) {
        this(content, (byte[])null);
    }

    public ByteArrayPayload(byte[] content, byte[] md5) {
        super(content);
        this.getContentMetadata().setContentLength(new Long(((byte[])Preconditions.checkNotNull((Object)content, (Object)"content")).length));
        this.getContentMetadata().setContentMD5(md5);
        Preconditions.checkArgument((content.length >= 0 ? 1 : 0) != 0, (Object)"length cannot me negative");
    }

    @Override
    public InputStream getInput() {
        return new ByteArrayInputStream((byte[])this.content);
    }
}

