/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.jclouds.javax.annotation.Nullable;

public class ClassMethodArgs {
    private final Class<?> clazz;
    private final Method method;
    private final Object[] args;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return ClassMethodArgs.builder().fromClassMethodArgs(this);
    }

    public ClassMethodArgs(Builder<?> builder) {
        this(((Builder)builder).clazz, ((Builder)builder).method, ((Builder)builder).args);
    }

    public ClassMethodArgs(Class<?> clazz, Method method, @Nullable Object[] args) {
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
        this.method = (Method)Preconditions.checkNotNull((Object)method, (Object)"method");
        this.args = args;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassMethodArgs that = (ClassMethodArgs)ClassMethodArgs.class.cast(o);
        return Objects.equal(this.clazz, that.clazz) && Objects.equal((Object)this.method, (Object)that.method) && Objects.equal((Object)this.args, (Object)that.args);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clazz, this.method, this.args});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("clazz", this.clazz).add("method", (Object)this.method).add("args", (Object)this.args);
    }

    public static abstract class Builder<B extends Builder<B>> {
        private Class<?> clazz;
        private Method method;
        private Object[] args;

        protected B self() {
            return (B)this;
        }

        public B clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this.self();
        }

        public B method(Method method) {
            this.method = method;
            return this.self();
        }

        public B args(Object[] args) {
            this.args = args;
            return this.self();
        }

        public ClassMethodArgs build() {
            return new ClassMethodArgs(this);
        }

        public B fromClassMethodArgs(ClassMethodArgs in) {
            return ((Builder)((Builder)this.clazz(in.getClazz())).method(in.getMethod())).args(in.getArgs());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }
    }
}

