/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.InputSuppliers;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.logging.Logger;
import org.jclouds.logging.internal.Wire;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class HttpUtils {
    @Inject(optional=true)
    @Named(value="jclouds.relax-hostname")
    private boolean relaxHostname = false;
    @Inject(optional=true)
    @Named(value="jclouds.use-system-proxy")
    private boolean systemProxies = System.getProperty("java.net.useSystemProxies") != null ? Boolean.parseBoolean(System.getProperty("java.net.useSystemProxies")) : false;
    private final int globalMaxConnections;
    private final int globalMaxConnectionsPerHost;
    private final int connectionTimeout;
    private final int soTimeout;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-host")
    private String proxyHost;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-port")
    private Integer proxyPort;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-user")
    private String proxyUser;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-password")
    private String proxyPassword;
    @Inject(optional=true)
    @Named(value="jclouds.trust-all-certs")
    private boolean trustAllCerts;

    @Inject
    public HttpUtils(@Named(value="jclouds.connection-timeout") int connectionTimeout, @Named(value="jclouds.so-timeout") int soTimeout, @Named(value="jclouds.max-connections-per-context") int globalMaxConnections, @Named(value="jclouds.max-connections-per-host") int globalMaxConnectionsPerHost) {
        this.soTimeout = soTimeout;
        this.connectionTimeout = connectionTimeout;
        this.globalMaxConnections = globalMaxConnections;
        this.globalMaxConnectionsPerHost = globalMaxConnectionsPerHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getSocketOpenTimeout() {
        return this.soTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean relaxHostname() {
        return this.relaxHostname;
    }

    public boolean trustAllCerts() {
        return this.trustAllCerts;
    }

    public boolean useSystemProxies() {
        return this.systemProxies;
    }

    public int getMaxConnections() {
        return this.globalMaxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.globalMaxConnectionsPerHost;
    }

    public static URI createBaseEndpointFor(URI endpoint) {
        if (endpoint.getPort() == -1) {
            return URI.create(String.format("%s://%s", endpoint.getScheme(), endpoint.getHost()));
        }
        return URI.create(String.format("%s://%s:%d", endpoint.getScheme(), endpoint.getHost(), endpoint.getPort()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArrayOrNull(PayloadEnclosing response) {
        if (response.getPayload() != null) {
            InputStream input = response.getPayload().getInput();
            try {
                byte[] byArray = ByteStreams.toByteArray((InputStream)input);
                return byArray;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            finally {
                Closeables.closeQuietly((Closeable)input);
            }
        }
        return null;
    }

    public static byte[] closeClientButKeepContentStream(PayloadEnclosing response) {
        byte[] returnVal = HttpUtils.toByteArrayOrNull(response);
        if (returnVal != null && !response.getPayload().isRepeatable()) {
            ByteArrayPayload newPayload = Payloads.newByteArrayPayload(returnVal);
            MutableContentMetadata fromMd = response.getPayload().getContentMetadata();
            MutableContentMetadata toMd = newPayload.getContentMetadata();
            HttpUtils.copy(fromMd, toMd);
            response.setPayload(newPayload);
        }
        return returnVal;
    }

    public static void copy(ContentMetadata fromMd, MutableContentMetadata toMd) {
        toMd.setContentLength(fromMd.getContentLength());
        toMd.setContentMD5(fromMd.getContentMD5());
        toMd.setContentType(fromMd.getContentType());
        toMd.setContentDisposition(fromMd.getContentDisposition());
        toMd.setContentEncoding(fromMd.getContentEncoding());
        toMd.setContentLanguage(fromMd.getContentLanguage());
        toMd.setExpires(fromMd.getExpires());
    }

    public static URI parseEndPoint(String hostHeader) {
        URI redirectURI = URI.create(hostHeader);
        String scheme = redirectURI.getScheme();
        Preconditions.checkState((boolean)redirectURI.getScheme().startsWith("http"), (Object)String.format("header %s didn't parse an http scheme: [%s]", hostHeader, scheme));
        int port = redirectURI.getPort() > 0 ? redirectURI.getPort() : (redirectURI.getScheme().equals("https") ? 443 : 80);
        String host = redirectURI.getHost();
        Preconditions.checkState((host.indexOf(47) == -1 ? 1 : 0) != 0, (Object)String.format("header %s didn't parse an http host correctly: [%s]", hostHeader, host));
        URI endPoint = URI.create(String.format("%s://%s:%d", scheme, host, port));
        return endPoint;
    }

    public static URI replaceHostInEndPoint(URI endPoint, String host) {
        return URI.create(endPoint.toString().replace(endPoint.getHost(), host));
    }

    public static URI createUri(String uriPath) {
        String path;
        ArrayList parts;
        ArrayList onQuery = Lists.newArrayList((Iterable)Splitter.on((char)'?').split((CharSequence)uriPath));
        if (onQuery.size() == 2) {
            onQuery.add(Strings2.urlEncode((String)onQuery.remove(1), '=', '&'));
            uriPath = Joiner.on((char)'?').join((Iterable)onQuery);
        }
        if (uriPath.indexOf(64) != 1) {
            parts = Lists.newArrayList((Iterable)Splitter.on((char)'@').split((CharSequence)uriPath));
            path = (String)parts.remove(parts.size() - 1);
            if (parts.size() > 1) {
                parts = Lists.newArrayList((Object[])new String[]{Strings2.urlEncode(Joiner.on((char)'@').join((Iterable)parts), '/', ':')});
            }
            parts.add(Strings2.urlEncode(path, '/', ':'));
            uriPath = Joiner.on((char)'@').join((Iterable)parts);
        } else {
            parts = Lists.newArrayList((Iterable)Splitter.on((char)'/').split((CharSequence)uriPath));
            path = (String)parts.remove(parts.size() - 1);
            parts.add(Strings2.urlEncode(path, ':'));
            uriPath = Joiner.on((char)'/').join((Iterable)parts);
        }
        if (Patterns.PATTERN_THAT_BREAKS_URI.matcher(uriPath).matches()) {
            Matcher matcher = Patterns.URI_PATTERN.matcher(uriPath);
            if (matcher.find()) {
                String scheme = matcher.group(1);
                String rest = matcher.group(4);
                String identity = matcher.group(2);
                String key = matcher.group(3);
                return URI.create(String.format("%s://%s:%s@%s", scheme, Strings2.urlEncode(identity, new char[0]), Strings2.urlEncode(key, new char[0]), rest));
            }
            throw new IllegalArgumentException("bad syntax");
        }
        return URI.create(uriPath);
    }

    public void logRequest(Logger logger, HttpRequest request, String prefix) {
        if (logger.isDebugEnabled()) {
            logger.debug("%s %s", prefix, request.getRequestLine().toString());
            this.logMessage(logger, request, prefix);
        }
    }

    private void logMessage(Logger logger, HttpMessage message, String prefix) {
        for (Map.Entry header : message.getHeaders().entries()) {
            if (header.getKey() == null) continue;
            logger.debug("%s %s: %s", prefix, header.getKey(), header.getValue());
        }
        if (message.getPayload() != null) {
            if (message.getPayload().getContentMetadata().getContentType() != null) {
                logger.debug("%s %s: %s", prefix, "Content-Type", message.getPayload().getContentMetadata().getContentType());
            }
            if (message.getPayload().getContentMetadata().getContentLength() != null) {
                logger.debug("%s %s: %s", prefix, "Content-Length", message.getPayload().getContentMetadata().getContentLength());
            }
            if (message.getPayload().getContentMetadata().getContentMD5() != null) {
                try {
                    logger.debug("%s %s: %s", prefix, "Content-MD5", CryptoStreams.base64Encode(InputSuppliers.of(message.getPayload().getContentMetadata().getContentMD5())));
                }
                catch (IOException e) {
                    logger.warn(e, " error getting md5 for %s", message);
                }
            }
            if (message.getPayload().getContentMetadata().getContentDisposition() != null) {
                logger.debug("%s %s: %s", prefix, "Content-Disposition", message.getPayload().getContentMetadata().getContentDisposition());
            }
            if (message.getPayload().getContentMetadata().getContentEncoding() != null) {
                logger.debug("%s %s: %s", prefix, "Content-Encoding", message.getPayload().getContentMetadata().getContentEncoding());
            }
            if (message.getPayload().getContentMetadata().getContentLanguage() != null) {
                logger.debug("%s %s: %s", prefix, "Content-Language", message.getPayload().getContentMetadata().getContentLanguage());
            }
            if (message.getPayload().getContentMetadata().getExpires() != null) {
                logger.debug("%s %s: %s", prefix, "Expires", message.getPayload().getContentMetadata().getExpires());
            }
        }
    }

    public void logResponse(Logger logger, HttpResponse response, String prefix) {
        if (logger.isDebugEnabled()) {
            logger.debug("%s %s", prefix, response.getStatusLine().toString());
            this.logMessage(logger, response, prefix);
        }
    }

    public static String sortAndConcatHeadersIntoString(Multimap<String, String> headers) {
        StringBuilder buffer = new StringBuilder();
        TreeMultimap sortedMap = TreeMultimap.create();
        sortedMap.putAll(headers);
        for (Map.Entry header : sortedMap.entries()) {
            if (header.getKey() == null) continue;
            buffer.append(String.format("%s: %s\n", header.getKey(), header.getValue()));
        }
        return buffer.toString();
    }

    public void checkRequestHasRequiredProperties(HttpRequest message) {
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Content-Type") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setContentType(value) as opposed to adding a content type header: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Content-Length") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setContentLength(value) as opposed to adding a content length header: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getPayload().getContentMetadata().getContentLength() != null || "chunked".equalsIgnoreCase(message.getFirstHeaderOrNull("Transfer-Encoding")) ? 1 : 0) != 0, (Object)("either chunked encoding must be set on the http request or contentlength set on the payload: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Content-MD5") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setContentMD5(value) as opposed to adding a content md5 header: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Content-Disposition") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setContentDisposition(value) as opposed to adding a content disposition header: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Content-Encoding") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setContentEncoding(value) as opposed to adding a content encoding header: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Content-Language") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setContentLanguage(value) as opposed to adding a content language header: " + message));
        Preconditions.checkArgument((message.getPayload() == null || message.getFirstHeaderOrNull("Expires") == null ? 1 : 0) != 0, (Object)("configuration error please use request.getPayload().getContentMetadata().setExpires(value) as opposed to adding an expires header: " + message));
    }

    public static void releasePayload(HttpMessage from) {
        if (from.getPayload() != null) {
            from.getPayload().release();
        }
    }

    public static String nullToEmpty(byte[] md5) {
        return md5 != null ? CryptoStreams.base64(md5) : "";
    }

    public static String nullToEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty() ? "" : collection.iterator().next();
    }

    public static Long attemptToParseSizeAndRangeFromHeaders(HttpMessage from) throws HttpException {
        String contentRange = from.getFirstHeaderOrNull("Content-Range");
        if (contentRange == null && from.getPayload() != null) {
            return from.getPayload().getContentMetadata().getContentLength();
        }
        if (contentRange != null) {
            return Long.parseLong(contentRange.substring(contentRange.lastIndexOf(47) + 1));
        }
        return null;
    }

    public static void checkRequestHasContentLengthOrChunkedEncoding(HttpMessage request, String message) {
        boolean chunked = "chunked".equals(request.getFirstHeaderOrNull("Transfer-Encoding"));
        Preconditions.checkArgument((request.getPayload() == null || chunked || request.getPayload().getContentMetadata().getContentLength() != null ? 1 : 0) != 0, (Object)message);
    }

    public static void wirePayloadIfEnabled(Wire wire, HttpMessage request) {
        if (request.getPayload() != null && wire.enabled()) {
            wire.output(request);
            HttpUtils.checkRequestHasContentLengthOrChunkedEncoding(request, "After wiring, the request has neither chunked encoding nor content length: " + request);
        }
    }

    public static <T> T returnValueOnCodeOrNull(Exception from, T value, Predicate<Integer> codePredicate) {
        Iterable throwables = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)from), HttpResponseException.class);
        if (Iterables.size((Iterable)throwables) >= 1 && ((HttpResponseException)Iterables.get((Iterable)throwables, (int)0)).getResponse() != null && codePredicate.apply((Object)((HttpResponseException)Iterables.get((Iterable)throwables, (int)0)).getResponse().getStatusCode())) {
            return value;
        }
        return null;
    }
}

