/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public class HttpRequest
extends HttpMessage {
    private final List<HttpRequestFilter> requestFilters;
    private final String method;
    private final URI endpoint;
    private final char[] skips;

    public static Builder builder() {
        return new Builder();
    }

    public HttpRequest(String method, URI endpoint) {
        this(method, endpoint, new char[0]);
    }

    public HttpRequest(String method, URI endpoint, char[] skips) {
        this(method, endpoint, skips, (List<HttpRequestFilter>)ImmutableList.of());
    }

    public HttpRequest(String method, URI endpoint, char[] skips, List<HttpRequestFilter> requestFilters) {
        this(method, endpoint, skips, requestFilters, null);
    }

    public HttpRequest(String method, URI endpoint, char[] skips, List<HttpRequestFilter> requestFilters, @Nullable Payload payload) {
        this(method, endpoint, skips, requestFilters, payload, (Multimap<String, String>)ImmutableMultimap.of());
    }

    public HttpRequest(String method, URI endpoint, Multimap<String, String> headers) {
        this(method, endpoint, new char[0], (List<HttpRequestFilter>)ImmutableList.of(), null, headers);
    }

    public HttpRequest(String method, URI endpoint, char[] skips, List<HttpRequestFilter> requestFilters, @Nullable Payload payload, Multimap<String, String> headers) {
        super(payload, headers);
        this.method = (String)Preconditions.checkNotNull((Object)method, (Object)"method");
        this.endpoint = (URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
        Preconditions.checkArgument((endpoint.getHost() != null ? 1 : 0) != 0, (Object)String.format("endpoint.getHost() is null for %s", endpoint));
        this.skips = (char[])Preconditions.checkNotNull((Object)skips, (Object)"skips");
        this.requestFilters = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(requestFilters, (Object)"requestFilters")));
    }

    protected HttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload) {
        this(method, endpoint, new char[0], (List<HttpRequestFilter>)ImmutableList.of(), payload, headers);
    }

    public String getRequestLine() {
        return String.format("%s %s HTTP/1.1", this.getMethod(), this.getEndpoint().toASCIIString());
    }

    public String getMethod() {
        return this.method;
    }

    public char[] getSkips() {
        return this.skips;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void addFilter(HttpRequestFilter filter) {
        this.requestFilters.add(filter);
    }

    public List<HttpRequestFilter> getFilters() {
        return this.requestFilters;
    }

    @Override
    public Builder toBuilder() {
        return Builder.from(this);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.method, this.endpoint, this.headers, this.payload});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)obj;
        if (!Objects.equal((Object)this.method, (Object)other.method)) {
            return false;
        }
        if (!Objects.equal((Object)this.endpoint, (Object)other.endpoint)) {
            return false;
        }
        if (!Objects.equal((Object)this.headers, (Object)other.headers)) {
            return false;
        }
        return Objects.equal((Object)this.payload, (Object)other.payload);
    }

    @Override
    public String toString() {
        return String.format("[method=%s, endpoint=%s, headers=%s, payload=%s]", this.method, this.endpoint, this.headers, this.payload);
    }

    public static class Builder
    extends HttpMessage.Builder {
        protected String method;
        protected URI endpoint;
        protected char[] skips = new char[0];
        protected List<HttpRequestFilter> requestFilters = ImmutableList.of();

        public Builder filters(List<HttpRequestFilter> requestFilters) {
            this.requestFilters = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(requestFilters, (Object)"requestFilters")));
            return this;
        }

        public Builder method(String method) {
            this.method = (String)Preconditions.checkNotNull((Object)method, (Object)"method");
            return this;
        }

        public Builder endpoint(URI endpoint) {
            this.endpoint = (URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
            return this;
        }

        public Builder skips(char[] skips) {
            char[] retval = new char[((char[])Preconditions.checkNotNull((Object)skips, (Object)"skips")).length];
            System.arraycopy(skips, 0, retval, 0, skips.length);
            this.skips = retval;
            return this;
        }

        @Override
        public Builder payload(Payload payload) {
            return (Builder)super.payload(payload);
        }

        @Override
        public Builder headers(Multimap<String, String> headers) {
            return (Builder)super.headers(headers);
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this.method, this.endpoint, this.skips, this.requestFilters, this.payload, (Multimap<String, String>)this.headers);
        }

        public static Builder from(HttpRequest input) {
            return new Builder().method(input.getMethod()).endpoint(input.getEndpoint()).skips(input.getSkips()).filters(input.getFilters()).payload(input.getPayload()).headers((Multimap)input.getHeaders());
        }
    }
}

