/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import net.oauth.signature.pem.PEMReader;
import net.oauth.signature.pem.PKCS1EncodedKeySpec;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.crypto.pem.PKCS1EncodedPublicKeySpec;
import org.jclouds.io.InputSuppliers;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class Pems {
    public static final String PRIVATE_PKCS1_MARKER = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PRIVATE_PKCS8_MARKER = "-----BEGIN PRIVATE KEY-----";
    public static final String CERTIFICATE_X509_MARKER = "-----BEGIN CERTIFICATE-----";
    public static final String PUBLIC_X509_MARKER = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_PKCS1_MARKER = "-----BEGIN RSA PUBLIC KEY-----";

    public static <T> T fromPem(InputSupplier<? extends InputStream> supplier, PemProcessor<T> processor) throws IOException {
        try {
            return (T)ByteStreams.readBytes(supplier, processor);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static KeySpec privateKeySpec(InputSupplier<? extends InputStream> supplier) throws IOException {
        return (KeySpec)Pems.fromPem(supplier, new PemProcessor(ImmutableMap.of((Object)PRIVATE_PKCS1_MARKER, (Object)new PemProcessor.ResultParser<KeySpec>(){

            @Override
            public KeySpec parseResult(byte[] bytes) throws IOException {
                return new PKCS1EncodedKeySpec(bytes).getKeySpec();
            }
        }, (Object)PRIVATE_PKCS8_MARKER, (Object)new PemProcessor.ResultParser<KeySpec>(){

            @Override
            public KeySpec parseResult(byte[] bytes) throws IOException {
                return new PKCS8EncodedKeySpec(bytes);
            }
        })));
    }

    public static KeySpec privateKeySpec(String pem) {
        try {
            return Pems.privateKeySpec(InputSuppliers.of(pem));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static KeySpec publicKeySpec(InputSupplier<? extends InputStream> supplier) throws IOException {
        return (KeySpec)Pems.fromPem(supplier, new PemProcessor(ImmutableMap.of((Object)PUBLIC_PKCS1_MARKER, (Object)new PemProcessor.ResultParser<KeySpec>(){

            @Override
            public KeySpec parseResult(byte[] bytes) throws IOException {
                return new PKCS1EncodedPublicKeySpec(bytes).getKeySpec();
            }
        }, (Object)PUBLIC_X509_MARKER, (Object)new PemProcessor.ResultParser<KeySpec>(){

            @Override
            public X509EncodedKeySpec parseResult(byte[] bytes) throws IOException {
                return new X509EncodedKeySpec(bytes);
            }
        })));
    }

    public static KeySpec publicKeySpec(String pem) throws IOException {
        return Pems.publicKeySpec(InputSuppliers.of(pem));
    }

    public static X509Certificate x509Certificate(InputSupplier<? extends InputStream> supplier, @Nullable CertificateFactory certFactory) throws IOException, CertificateException {
        final CertificateFactory finalCertFactory = certFactory != null ? certFactory : CertificateFactory.getInstance("X.509");
        try {
            return (X509Certificate)Pems.fromPem(supplier, new PemProcessor(ImmutableMap.of((Object)CERTIFICATE_X509_MARKER, (Object)new PemProcessor.ResultParser<X509Certificate>(){

                @Override
                public X509Certificate parseResult(byte[] bytes) throws IOException {
                    try {
                        return (X509Certificate)finalCertFactory.generateCertificate(new ByteArrayInputStream(bytes));
                    }
                    catch (CertificateException e) {
                        throw new RuntimeException(e);
                    }
                }
            })));
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof CertificateException) {
                throw (CertificateException)e.getCause();
            }
            throw e;
        }
    }

    public static X509Certificate x509Certificate(String pem) throws IOException, CertificateException {
        return Pems.x509Certificate(InputSuppliers.of(pem), null);
    }

    public static String pem(X509Certificate cert) throws CertificateEncodingException {
        String marker = CERTIFICATE_X509_MARKER;
        return Pems.pem(cert.getEncoded(), marker);
    }

    public static String pem(PublicKey key) {
        String marker = key instanceof RSAPublicKey ? PUBLIC_PKCS1_MARKER : PUBLIC_X509_MARKER;
        return Pems.pem(key.getEncoded(), marker);
    }

    public static String pem(PrivateKey key) {
        String marker = key instanceof RSAPrivateCrtKey ? PRIVATE_PKCS1_MARKER : PRIVATE_PKCS8_MARKER;
        return Pems.pem(key instanceof RSAPrivateCrtKey ? Pems.getEncoded((RSAPrivateCrtKey)RSAPrivateCrtKey.class.cast(key)) : key.getEncoded(), marker);
    }

    public static byte[] getEncoded(RSAPrivateCrtKey key) {
        RSAPrivateKeyStructure keyStruct = new RSAPrivateKeyStructure(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        try {
            aOut.writeObject((Object)keyStruct);
            aOut.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return bOut.toByteArray();
    }

    private static String pem(byte[] key, String marker) {
        return Pems.pem(key, marker, 64);
    }

    static String pem(byte[] key, String marker, int length) {
        return (marker + "\n" + Joiner.on((char)'\n').join(Splitter.fixedLength((int)length).split((CharSequence)CryptoStreams.base64(key))) + ("\n" + marker.replace("BEGIN", "END") + "\n")).trim();
    }

    public static class PemProcessor<T>
    implements ByteProcessor<T> {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final Map<String, ResultParser<T>> parsers;

        public PemProcessor(Map<String, ResultParser<T>> parsers) {
            this.parsers = (Map)Preconditions.checkNotNull(parsers, (Object)"parsers");
        }

        public boolean processBytes(byte[] buf, int off, int len) {
            this.out.write(buf, off, len);
            return true;
        }

        public T getResult() {
            try {
                PEMReader reader = new PEMReader(this.out.toByteArray());
                byte[] bytes = reader.getDerBytes();
                if (this.parsers.containsKey(reader.getBeginMarker())) {
                    return this.parsers.get(reader.getBeginMarker()).parseResult(bytes);
                }
                throw new IOException(String.format("Invalid PEM file: no parsers for marker %s in %s", reader.getBeginMarker(), this.parsers.keySet()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static interface ResultParser<T> {
            public T parseResult(byte[] var1) throws IOException;
        }
    }
}

