/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class PaginatedSet<T>
extends ForwardingSet<T> {
    private final Set<T> contents;
    private final String marker;

    public static <T> PaginatedSet<T> copyOf(Iterable<T> contents) {
        return new PaginatedSet<T>(contents, null);
    }

    public static <T> PaginatedSet<T> copyOfWithMarker(Iterable<T> contents, String marker) {
        return new PaginatedSet<T>(contents, marker);
    }

    protected PaginatedSet(Iterable<T> contents, @Nullable String marker) {
        this.contents = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(contents, (Object)"contents")));
        this.marker = marker;
    }

    @Nullable
    public String getNextMarker() {
        return this.marker;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.contents, this.marker});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PaginatedSet other = (PaginatedSet)((Object)PaginatedSet.class.cast(obj));
        return Objects.equal(this.contents, other.contents) && Objects.equal((Object)this.marker, (Object)other.marker);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("contents", this.contents).add("marker", (Object)this.marker).toString();
    }

    protected Set<T> delegate() {
        return this.contents;
    }
}

