/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.jcloud;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.enterprise.config.EnterpriseConfigurationModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.wso2.carbon.autoscaler.service.util.IaasProvider;

public class ComputeServiceBuilder {
    public static ComputeService buildComputeService(IaasProvider iaas) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : iaas.getProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        ImmutableSet modules = ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new SLF4JLoggingModule(), (Object)new EnterpriseConfigurationModule());
        ContextBuilder builder = ContextBuilder.newBuilder((String)iaas.getProvider()).credentials(iaas.getIdentity(), iaas.getCredential()).modules((Iterable)modules).overrides(properties);
        return ((ComputeServiceContext)builder.buildView(ComputeServiceContext.class)).getComputeService();
    }
}

