/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Serializer {
    private static final Log log = LogFactory.getLog(Serializer.class);

    public static void serialize(Object serializableObj, String filePath) throws IOException {
        File outFile = new File(filePath);
        ObjectOutput ObjOut = null;
        try {
            if (outFile.createNewFile()) {
                log.debug((Object)("Serialization file is created at " + filePath));
            } else {
                log.debug((Object)("Serialization file is already existing at " + filePath));
            }
            ObjOut = new ObjectOutputStream(new FileOutputStream(outFile));
            ObjOut.writeObject(serializableObj);
        }
        catch (IOException e) {
            log.error((Object)("Failed to serialize the object " + serializableObj.toString() + " to file " + filePath), (Throwable)e);
            throw e;
        }
        finally {
            ObjOut.close();
        }
    }
}

