/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.wso2.carbon.autoscaler.service.IAutoscalerService;
import org.wso2.carbon.autoscaler.service.exception.AutoscalerServiceException;
import org.wso2.carbon.autoscaler.service.exception.DeserializationException;
import org.wso2.carbon.autoscaler.service.exception.SerializationException;
import org.wso2.carbon.autoscaler.service.io.Deserializer;
import org.wso2.carbon.autoscaler.service.io.Serializer;
import org.wso2.carbon.autoscaler.service.jcloud.ComputeServiceBuilder;
import org.wso2.carbon.autoscaler.service.util.IaasContext;
import org.wso2.carbon.autoscaler.service.util.IaasProvider;
import org.wso2.carbon.autoscaler.service.util.ServiceTemplate;
import org.wso2.carbon.autoscaler.service.xml.ElasticScalerConfigFileReader;
import org.wso2.carbon.utils.CarbonUtils;

public class AutoscalerServiceImpl
implements IAutoscalerService {
    private static final String VALUE_SEPARATOR = "=";
    private static final String ENTRY_SEPARATOR = ",";
    private static final String APP_PATH_KEY = "APP_PATH";
    private static final String TENANT_KEY = "TENANT";
    private static final String SUPER_TENANT_ID = "-1234";
    private static final Log log = LogFactory.getLog(AutoscalerServiceImpl.class);
    private static final String CARBON_HOME = CarbonUtils.getCarbonHome();
    private static final String CARBON_TEMP = CarbonUtils.getTmpDir();
    private static final String TENANT_ID_DELIMITER = "/t/";
    private String serializationDir;
    private List<IaasProvider> iaasProviders;
    private List<ServiceTemplate> serviceTemps;
    private List<IaasContext> iaasContextList = new ArrayList<IaasContext>();
    private Map<String, String> domainToLastlyUsedIaasMap = new HashMap<String, String>();
    boolean isInitialized = false;

    @Override
    public boolean initAutoscaler(boolean isSpi) {
        log.debug((Object)("InitAutoscaler has started ...  IsSPI : " + isSpi));
        ElasticScalerConfigFileReader configReader = new ElasticScalerConfigFileReader();
        this.serializationDir = configReader.getSerializationDir();
        if ("".equals(this.serializationDir)) {
            this.serializationDir = CARBON_TEMP;
            log.debug((Object)("Directory to be used to serialize objects: " + this.serializationDir));
        }
        this.deserialize();
        this.iaasProviders = configReader.getIaasProvidersList();
        this.serviceTemps = configReader.getTemplates();
        for (IaasProvider iaas : this.iaasProviders) {
            ComputeService computeService = ComputeServiceBuilder.buildComputeService(iaas);
            IaasContext entity = this.findIaasContext(iaas.getType());
            if (entity != null) {
                log.debug((Object)("Serializable object is loaded for IaaS " + iaas.getType()));
                entity.setComputeService(computeService);
            }
            if (iaas.getType().equalsIgnoreCase(Iaases.ec2.toString())) {
                IaasContext iaasContext = entity = entity == null ? (entity = new IaasContext(Iaases.ec2, computeService)) : entity;
                if (!isSpi) {
                    this.buildEC2Templates(entity, iaas.getTemplate(), isSpi);
                } else {
                    this.iaasContextList.add(entity);
                }
            } else if (iaas.getType().equalsIgnoreCase(Iaases.openstack.toString())) {
                IaasContext iaasContext = entity = entity == null ? (entity = new IaasContext(Iaases.openstack, computeService)) : entity;
                if (!isSpi) {
                    this.buildLXCTemplates(entity, iaas.getTemplate(), isSpi, null);
                } else {
                    this.iaasContextList.add(entity);
                }
            } else {
                String msg = "Unsupported IaasProvider is specified in the config file: " + iaas.getType() + ". Supported IaasProviders are " + this.print(Iaases.values());
                log.warn((Object)msg);
                continue;
            }
            this.fillInScaleUpOrder();
            this.fillInScaleDownOrder();
            this.serialize();
        }
        if (this.iaasContextList.size() == 0) {
            String msg = "No valid IaaS provider specified in the config file!";
            log.error((Object)msg);
            throw new AutoscalerServiceException(msg);
        }
        this.isInitialized = true;
        log.info((Object)"Autoscaler service initialized successfully!!");
        return true;
    }

    @Override
    public boolean startInstance(String domainName) {
        this.initialize(false);
        log.info((Object)("Starting new instance of domain : " + domainName));
        Collections.sort(this.iaasContextList, IaasContextComparator.ascending(IaasContextComparator.getComparator(IaasContextComparator.SCALE_UP_SORT)));
        for (IaasContext iaasCtxt : this.iaasContextList) {
            block6: {
                ComputeService computeService = iaasCtxt.getComputeService();
                Template template = iaasCtxt.getTemplate(domainName);
                String group = domainName.contains(".") ? domainName.replace('.', '-') : domainName;
                try {
                    Set nodes = computeService.createNodesInGroup(group, 1, template);
                    NodeMetadata node = (NodeMetadata)nodes.iterator().next();
                    iaasCtxt.addNodeIdToDomainMap(node.getId(), domainName);
                    if (node.getPublicAddresses().size() > 0) {
                        String publicIp = (String)node.getPublicAddresses().iterator().next();
                        iaasCtxt.addPublicIpToDomainMap(publicIp, domainName);
                        iaasCtxt.addPublicIpToNodeIdMap(publicIp, node.getId());
                    } else if (node.getPrivateAddresses().size() > 0) {
                        String privateIp = (String)node.getPrivateAddresses().iterator().next();
                        iaasCtxt.addPublicIpToDomainMap(privateIp, domainName);
                        iaasCtxt.addPublicIpToNodeIdMap(privateIp, node.getId());
                    }
                    this.replaceIaasContext(iaasCtxt);
                    this.domainToLastlyUsedIaasMap.put(domainName, iaasCtxt.getName().toString());
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("Node details: \n" + node.toString() + "\n***************\n"));
                }
                catch (RunNodesException e) {
                    log.warn((Object)("Failed to start an instance in " + iaasCtxt.getName().toString() + ". Hence, will try to start in another IaaS if available."), (Throwable)e);
                    continue;
                }
            }
            log.info((Object)("Instance is successfully starting up in IaaS " + iaasCtxt.getName().toString() + " ..."));
            this.serialize();
            return true;
        }
        log.info((Object)"Failed to start instance, in any available IaaS.");
        return false;
    }

    @Override
    public String startSpiInstance(String domainName, String imageId) {
        IaasContext entry;
        log.debug((Object)("Starting an SPI instance ... | domain: " + domainName + " | ImageId: " + imageId));
        this.initialize(true);
        String tenantId = null;
        String spiDomainName = null;
        if (domainName != null) {
            String[] arr = domainName.split(TENANT_ID_DELIMITER);
            if (arr.length != 2) {
                String msg = "Domain name does not match with the expected pattern";
                log.error((Object)msg);
                throw new AutoscalerServiceException(msg);
            }
            spiDomainName = arr[0];
            tenantId = arr[1];
        }
        if (imageId.startsWith("nova") && (entry = this.findIaasContext(Iaases.openstack)) != null) {
            this.buildLXCTemplates(entry, imageId, true, tenantId);
        } else {
            entry = this.findIaasContext(Iaases.ec2);
            if (entry != null) {
                this.buildEC2Templates(entry, imageId, true);
            } else {
                String msg = "Invalid image id: " + imageId;
                log.error((Object)msg);
                throw new AutoscalerServiceException(msg);
            }
        }
        if (this.startInstance(spiDomainName)) {
            String publicIP = entry.getLastMatchingPublicIp(spiDomainName);
            return publicIP == null ? "" : publicIP;
        }
        return "";
    }

    @Override
    public boolean terminateInstance(String domainName) {
        this.initialize(false);
        log.info((Object)("Starting to terminate an instance of domain : " + domainName));
        Collections.sort(this.iaasContextList, IaasContextComparator.ascending(IaasContextComparator.getComparator(IaasContextComparator.SCALE_DOWN_SORT)));
        for (IaasContext iaasTemp : this.iaasContextList) {
            String msg = "Failed to terminate an instance in " + iaasTemp.getName().toString() + ". Hence, will try to terminate an instance in another IaaS if possible.";
            String nodeId = null;
            for (String id : iaasTemp.getNodeIds(domainName)) {
                if (id == null) continue;
                nodeId = id;
                break;
            }
            if (nodeId == null) {
                log.warn((Object)(msg + " : Reason- No matching instance found for domain '" + domainName + "'."));
                continue;
            }
            this.terminate(iaasTemp, nodeId);
            return true;
        }
        log.info((Object)("Termination of an instance which is belong to domain '" + domainName + "', failed!"));
        return false;
    }

    @Override
    public boolean terminateLastlySpawnedInstance(String domainName) {
        this.initialize(false);
        if (this.domainToLastlyUsedIaasMap.containsKey(domainName)) {
            String iaas = this.domainToLastlyUsedIaasMap.get(domainName);
            IaasContext iaasTemp = this.findIaasContext(iaas);
            String msg = "Failed to terminate the lastly spawned instance of '" + domainName + "' service domain.";
            if (iaasTemp == null) {
                log.error((Object)(msg + " : Reason- Iaas' data cannot be located!"));
                return false;
            }
            String nodeId = iaasTemp.getLastMatchingNode(domainName);
            if (nodeId == null) {
                log.error((Object)(msg + " : Reason- No matching instance found for domain '" + domainName + "'."));
                return false;
            }
            this.terminate(iaasTemp, nodeId);
            return true;
        }
        log.info((Object)("Termination of an instance which is belong to domain '" + domainName + "', failed!"));
        return false;
    }

    @Override
    public boolean terminateSpiInstance(String publicIp) {
        this.initialize(true);
        Collections.sort(this.iaasContextList, IaasContextComparator.ascending(IaasContextComparator.getComparator(IaasContextComparator.SCALE_DOWN_SORT)));
        for (IaasContext iaasTemp : this.iaasContextList) {
            String msg = "Failed to terminate an instance in " + iaasTemp.getName().toString() + "" + ". Hence, will try to terminate an instance in another IaaS if possible.";
            String nodeId = iaasTemp.getNodeWithPublicIp(publicIp);
            if (nodeId == null) {
                log.warn((Object)(msg + " : Reason- No matching instance found for public ip '" + publicIp + "'."));
                continue;
            }
            this.terminate(iaasTemp, nodeId);
            return true;
        }
        log.info((Object)("Termination of an instance which has the public IP '" + publicIp + "', failed!"));
        return false;
    }

    @Override
    public int getPendingInstanceCount(String domainName) {
        this.initialize(false);
        int pendingInstanceCount = 0;
        for (IaasContext entry : this.iaasContextList) {
            ComputeService computeService = entry.getComputeService();
            List<String> nodeIds = entry.getNodeIds(domainName);
            Set set = computeService.listNodes();
            for (NodeMetadataImpl nodeMetadata : set) {
                NodeMetadata.Status nodeStatus;
                if (!nodeIds.contains(nodeMetadata.getId()) || !(nodeStatus = nodeMetadata.getStatus()).toString().equalsIgnoreCase("PENDING")) continue;
                ++pendingInstanceCount;
            }
        }
        log.info((Object)("Pending instance count of domain '" + domainName + "' is " + pendingInstanceCount));
        return pendingInstanceCount;
    }

    private IaasContext findIaasContext(Enum<Iaases> iaas) {
        for (IaasContext entry : this.iaasContextList) {
            if (!entry.getName().equals(iaas)) continue;
            return entry;
        }
        return null;
    }

    private IaasContext findIaasContext(String iaasType) {
        for (IaasContext entry : this.iaasContextList) {
            if (!entry.getName().toString().equals(iaasType)) continue;
            return entry;
        }
        return null;
    }

    private void fillInScaleDownOrder() {
        for (IaasProvider iaas : this.iaasProviders) {
            if (this.findIaasContext(iaas.getType()) == null) continue;
            this.findIaasContext(iaas.getType()).setScaleDownOrder(iaas.getScaleDownOrder());
        }
    }

    private void fillInScaleUpOrder() {
        for (IaasProvider iaas : this.iaasProviders) {
            if (this.findIaasContext(iaas.getType()) == null) continue;
            this.findIaasContext(iaas.getType()).setScaleUpOrder(iaas.getScaleUpOrder());
        }
    }

    private byte[] getUserData(String payloadFileName, String tenantId) {
        byte[] bytes = null;
        try {
            File file = new File(payloadFileName);
            if (!file.exists()) {
                this.handleException("Payload file " + payloadFileName + " does not exist");
            }
            if (!file.canRead()) {
                this.handleException("Payload file " + payloadFileName + " does cannot be read");
            }
            if (tenantId != null) {
                this.editPayload(tenantId, file);
            }
            bytes = this.getBytesFromFile(file);
        }
        catch (IOException e) {
            AutoscalerServiceImpl.handleException("Cannot read data from payload file " + payloadFileName, e);
        }
        return bytes;
    }

    private void editPayload(String tenantName, File file) {
        this.unzipFile(file);
        this.editContent(tenantName, file);
        this.zipPayloadFile();
    }

    private void unzipFile(File file) {
        int buffer = 2048;
        BufferedOutputStream dest = null;
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(file);
            zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                log.debug((Object)("Extracting: " + entry));
                byte[] data = new byte[buffer];
                String outputFilename = "tmpPayload" + File.separator + entry.getName();
                this.createDirIfNeeded("tmpPayload", entry);
                if (entry.isDirectory()) continue;
                FileOutputStream fos = new FileOutputStream(outputFilename);
                dest = new BufferedOutputStream(fos, buffer);
                while ((count = zis.read(data, 0, buffer)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            this.closeStream(zis);
            this.closeStream(dest);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Exception is occurred in unzipping payload file. Reason:" + e.getMessage()));
                throw new AutoscalerServiceException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeStream(zis);
                this.closeStream(dest);
                throw throwable;
            }
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error((Object)(" Exception is occurred when closing stream. Reason :" + e.getMessage()));
            }
        }
    }

    private void editContent(String tenantName, File file) {
        File f = new File(CARBON_HOME + File.separator + "tmpPayload" + File.separator + "payload" + File.separator + "launch-params");
        FileInputStream fs = null;
        InputStreamReader in = null;
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            String textinLine;
            fs = new FileInputStream(f);
            in = new InputStreamReader(fs);
            br = new BufferedReader(in);
            while ((textinLine = br.readLine()) != null) {
                sb.append(this.editLine(textinLine, tenantName));
            }
            this.closeStream(fs);
            this.closeStream(in);
            this.closeStream(br);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Exception is occurred in editing payload content. Reason: " + e.getMessage()));
                throw new AutoscalerServiceException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeStream(fs);
                this.closeStream(in);
                this.closeStream(br);
                throw throwable;
            }
        }
        this.writeChangesBackToFile(f, sb);
    }

    private String editLine(String textinLine, String tenantName) {
        StringBuffer outputBuffer = new StringBuffer();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] params = textinLine.split(ENTRY_SEPARATOR);
        for (int i = 0; i < params.length; ++i) {
            String value;
            String param = params[i];
            String[] values = param.split(VALUE_SEPARATOR);
            if (values.length != 2) {
                throw new AutoscalerServiceException("Incorrect format in parameters file");
            }
            String key = values[0];
            String updatedValue = value = values[1];
            if (TENANT_KEY.equals(key)) {
                updatedValue = tenantName;
            } else if (APP_PATH_KEY.equals(key)) {
                updatedValue = this.getAppPathForTenant(tenantName, value);
            }
            paramMap.put(key, updatedValue);
        }
        this.reOrganizeContent(outputBuffer, paramMap);
        if (outputBuffer.substring(0, 1).equals(ENTRY_SEPARATOR)) {
            outputBuffer.delete(0, 1);
        }
        return outputBuffer.toString();
    }

    private void reOrganizeContent(StringBuffer outputBuffer, Map<String, String> paramMap) {
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            outputBuffer.append(ENTRY_SEPARATOR).append(entry.getKey()).append(VALUE_SEPARATOR).append(entry.getValue());
        }
    }

    private String getAppPathForTenant(String tenantName, String appPath) {
        StringBuffer updatedAppPath = new StringBuffer();
        if (tenantName.equals(SUPER_TENANT_ID)) {
            updatedAppPath.append(appPath).append("deployment").append(File.separator).append("server").append(File.separator).append("phpapps");
        } else {
            updatedAppPath.append(appPath).append(tenantName).append(File.separator).append("phpapps");
        }
        return updatedAppPath.toString();
    }

    private void writeChangesBackToFile(File f, StringBuffer sb) {
        FileWriter fstream = null;
        BufferedWriter outobj = null;
        try {
            fstream = new FileWriter(f);
            outobj = new BufferedWriter(fstream);
            outobj.write(sb.toString());
            this.closeStream(outobj);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeStream(outobj);
                throw throwable;
            }
        }
    }

    private void zipPayloadFile() {
        int buffer = 2048;
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        try {
            FileOutputStream dest = new FileOutputStream(CARBON_HOME + File.separator + "resources" + File.separator + "payload.zip");
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[buffer];
            File f = new File(CARBON_HOME + File.separator + "tmpPayload" + File.separator + "payload");
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                int count;
                FileInputStream fi = new FileInputStream(CARBON_HOME + File.separator + "tmpPayload" + File.separator + "payload" + File.separator + files[i]);
                origin = new BufferedInputStream(fi, buffer);
                ZipEntry entry = new ZipEntry("payload" + File.separator + files[i]);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, buffer)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            this.closeStream(origin);
            this.closeStream(out);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Exception is occurred in zipping payload file after modification. Reason:" + e.getMessage()));
                throw new AutoscalerServiceException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeStream(origin);
                this.closeStream(out);
                throw throwable;
            }
        }
    }

    private void createDirIfNeeded(String destDirectory, ZipEntry entry) {
        String name = entry.getName();
        if (name.contains("/")) {
            log.debug((Object)"directory will need to be created");
            int index = name.lastIndexOf("/");
            String dirSequence = name.substring(0, index);
            File newDirs = new File(destDirectory + File.separator + dirSequence);
            newDirs.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        if (!file.exists()) {
            log.error((Object)("Payload file " + file.getAbsolutePath() + " does not exist"));
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            int offset;
            int numRead;
            long length = file.length();
            if (length > Integer.MAX_VALUE && log.isDebugEnabled()) {
                log.debug((Object)"File is too large");
            }
            bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void replaceIaasContext(IaasContext replacement) {
        for (IaasContext entry : this.iaasContextList) {
            if (!entry.equals(replacement)) continue;
            int idx = this.iaasContextList.indexOf(entry);
            this.iaasContextList.remove(idx);
            this.iaasContextList.add(idx, replacement);
            return;
        }
        this.iaasContextList.add(replacement);
    }

    private void buildLXCTemplates(IaasContext entity, String imageId, boolean blockUntilRunning, String tenantId) {
        if (entity.getComputeService() == null) {
            throw new AutoscalerServiceException("Compute service is null for IaaS provider: " + entity.getName());
        }
        if (entity.getDomainToTemplateMap() == null) {
            entity.setDomainToTemplateMap(new HashMap<String, Template>());
        }
        TemplateBuilder templateBuilder = entity.getComputeService().templateBuilder();
        templateBuilder.imageId(imageId);
        for (ServiceTemplate temp : this.serviceTemps) {
            String instanceType = temp.getProperty("instanceType." + Iaases.openstack.toString());
            if (instanceType != null) {
                templateBuilder.hardwareId(instanceType);
            }
            Template template = templateBuilder.build();
            template.getOptions().as(TemplateOptions.class).blockUntilRunning(blockUntilRunning);
            ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).securityGroupNames(temp.getProperty("securityGroups").split(ENTRY_SEPARATOR));
            if (temp.getProperty("payload") != null) {
                ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).userData(this.getUserData(CARBON_HOME + File.separator + temp.getProperty("payload"), tenantId));
            }
            ((NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class)).keyPairName(temp.getProperty("keyPair"));
            entity.addToDomainToTemplateMap(temp.getDomainName(), template);
        }
        this.replaceIaasContext(entity);
    }

    private void buildEC2Templates(IaasContext entity, String imageId, boolean blockUntilRunning) {
        if (entity.getComputeService() == null) {
            throw new AutoscalerServiceException("Compute service is null for IaaS provider: " + entity.getName());
        }
        if (entity.getDomainToTemplateMap() == null) {
            entity.setDomainToTemplateMap(new HashMap<String, Template>());
        }
        TemplateBuilder templateBuilder = entity.getComputeService().templateBuilder();
        templateBuilder.imageId(imageId);
        for (ServiceTemplate temp : this.serviceTemps) {
            if (temp.getProperty("instanceType." + Iaases.ec2.toString()) != null) {
                templateBuilder.hardwareId(temp.getProperty("instanceType." + Iaases.ec2.toString()));
            }
            Template template = templateBuilder.build();
            template.getOptions().as(TemplateOptions.class).blockUntilRunning(blockUntilRunning);
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).placementGroup(temp.getProperty("availabilityZone"));
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).securityGroups(temp.getProperty("securityGroups").split(ENTRY_SEPARATOR));
            if (temp.getProperty("payload") != null) {
                ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).userData(this.getUserData(CARBON_HOME + File.separator + temp.getProperty("payload"), null));
            }
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).keyPair(temp.getProperty("keyPair"));
            entity.addToDomainToTemplateMap(temp.getDomainName(), template);
        }
        this.replaceIaasContext(entity);
    }

    private void initialize(boolean isSpi) {
        if (!this.isInitialized) {
            this.initAutoscaler(isSpi);
        }
    }

    private String print(Iaases[] values) {
        String str = "";
        for (Iaases iaases : values) {
            str = iaases.name() + ", ";
        }
        return (str = str.trim()).endsWith(ENTRY_SEPARATOR) ? str.substring(0, str.length() - 1) : str;
    }

    private void deserialize() {
        try {
            String path = this.serializationDir + File.separator + "iaas-context-list.txt";
            Object obj = Deserializer.deserialize(path);
            if (obj != null) {
                this.iaasContextList = (List)obj;
                log.debug((Object)("Deserialization was successful from file: " + path));
            }
            if ((obj = Deserializer.deserialize(path = this.serializationDir + File.separator + "domain-to-lastly-used-iaas.txt")) != null) {
                this.domainToLastlyUsedIaasMap = (Map)obj;
                log.debug((Object)("Deserialization was successful from file: " + path));
            }
        }
        catch (Exception e) {
            String msg = "Deserialization of objects failed!";
            log.fatal((Object)msg, (Throwable)e);
            throw new DeserializationException(msg, e);
        }
    }

    private void serialize() {
        try {
            Serializer.serialize(this.iaasContextList, this.serializationDir + File.separator + "iaas-context-list.txt");
            Serializer.serialize(this.domainToLastlyUsedIaasMap, this.serializationDir + File.separator + "domain-to-lastly-used-iaas.txt");
        }
        catch (IOException e) {
            String msg = "Serialization of objects failed!";
            log.fatal((Object)msg, (Throwable)e);
            throw new SerializationException(msg, e);
        }
    }

    private void terminate(IaasContext iaasTemp, String nodeId) {
        if (iaasTemp.getComputeService() == null) {
            String msg = "Unexpeced error occured! IaasContext's ComputeService is null!";
            log.error((Object)msg);
            throw new AutoscalerServiceException(msg);
        }
        iaasTemp.getComputeService().destroyNode(nodeId);
        iaasTemp.removeNodeId(nodeId);
        this.replaceIaasContext(iaasTemp);
        this.serialize();
        log.info((Object)("Node with Id: '" + nodeId + "' is terminated!"));
    }

    public static enum IaasContextComparator implements Comparator<IaasContext>
    {
        SCALE_UP_SORT{

            @Override
            public int compare(IaasContext o1, IaasContext o2) {
                return Integer.valueOf(o1.getScaleUpOrder()).compareTo(o2.getScaleUpOrder());
            }
        }
        ,
        SCALE_DOWN_SORT{

            @Override
            public int compare(IaasContext o1, IaasContext o2) {
                return Integer.valueOf(o1.getScaleDownOrder()).compareTo(o2.getScaleDownOrder());
            }
        };


        public static Comparator<IaasContext> ascending(final Comparator<IaasContext> other) {
            return new Comparator<IaasContext>(){

                @Override
                public int compare(IaasContext o1, IaasContext o2) {
                    return other.compare(o1, o2);
                }
            };
        }

        public static Comparator<IaasContext> getComparator(final IaasContextComparator ... multipleOptions) {
            return new Comparator<IaasContext>(){

                @Override
                public int compare(IaasContext o1, IaasContext o2) {
                    for (IaasContextComparator option : multipleOptions) {
                        int result = option.compare(o1, o2);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            };
        }
    }

    public static enum Iaases {
        ec2,
        openstack;

    }
}

