/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;

public class OAuthAuthenticationHandler
implements AuthenticationHandler {
    public static final String REQUESTOR_ID_PARAM = "xoauth_requestor_id";
    private final OAuthDataStore store;
    @Deprecated
    private final boolean allowLegacyBodySigning;

    @Inject
    public OAuthAuthenticationHandler(OAuthDataStore store, @Named(value="shindig.oauth.legacy-body-signing") boolean allowLegacyBodySigning) {
        this.store = store;
        this.allowLegacyBodySigning = allowLegacyBodySigning;
    }

    public String getName() {
        return "OAuth";
    }

    public String getWWWAuthenticateHeader(String realm) {
        return String.format("OAuth realm=\"%s\"", realm);
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        OAuthMessage message = OAuthServlet.getMessage(request, null);
        if (StringUtils.isEmpty((String)OAuthAuthenticationHandler.getParameter(message, "oauth_signature"))) {
            return null;
        }
        String bodyHash = OAuthAuthenticationHandler.getParameter(message, "oauth_body_hash");
        if (!StringUtils.isEmpty((String)bodyHash)) {
            OAuthAuthenticationHandler.verifyBodyHash(request, bodyHash);
        }
        try {
            return this.verifyMessage(message);
        }
        catch (OAuthProblemException oauthException) {
            if (this.allowLegacyBodySigning && (StringUtils.isEmpty((String)request.getContentType()) || !request.getContentType().contains("application/x-www-form-urlencoded"))) {
                try {
                    message.addParameter(OAuthAuthenticationHandler.readBodyString(request), "");
                    return this.verifyMessage(message);
                }
                catch (OAuthProblemException ioe) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw new AuthenticationHandler.InvalidAuthenticationException("OAuth Authentication Failure", oauthException);
        }
    }

    protected SecurityToken verifyMessage(OAuthMessage message) throws OAuthProblemException {
        OAuthEntry entry = this.getOAuthEntry(message);
        OAuthConsumer authConsumer = this.getConsumer(message);
        OAuthAccessor accessor = new OAuthAccessor(authConsumer);
        if (entry != null) {
            accessor.tokenSecret = entry.tokenSecret;
            accessor.accessToken = entry.token;
        }
        try {
            message.validateMessage(accessor, new SimpleOAuthValidator());
        }
        catch (OAuthProblemException e) {
            throw e;
        }
        catch (OAuthException e) {
            OAuthProblemException ope = new OAuthProblemException("signature_invalid");
            ope.setParameter("oauth_problem_advice", e.getMessage());
            throw ope;
        }
        catch (IOException e) {
            OAuthProblemException ope = new OAuthProblemException("signature_invalid");
            ope.setParameter("oauth_problem_advice", e.getMessage());
            throw ope;
        }
        catch (URISyntaxException e) {
            OAuthProblemException ope = new OAuthProblemException("signature_invalid");
            ope.setParameter("oauth_problem_advice", e.getMessage());
            throw ope;
        }
        return this.getTokenFromVerifiedRequest(message, entry, authConsumer);
    }

    protected OAuthEntry getOAuthEntry(OAuthMessage message) throws OAuthProblemException {
        OAuthEntry entry = null;
        String token = OAuthAuthenticationHandler.getParameter(message, "oauth_token");
        if (!StringUtils.isEmpty((String)token)) {
            entry = this.store.getEntry(token);
            if (entry == null) {
                OAuthProblemException e = new OAuthProblemException("token_rejected");
                e.setParameter("oauth_problem_advice", "cannot find token");
                throw e;
            }
            if (entry.type != OAuthEntry.Type.ACCESS) {
                OAuthProblemException e = new OAuthProblemException("token_rejected");
                e.setParameter("oauth_problem_advice", "token is not an access token");
                throw e;
            }
            if (entry.isExpired()) {
                throw new OAuthProblemException("token_expired");
            }
        }
        return entry;
    }

    protected OAuthConsumer getConsumer(OAuthMessage message) throws OAuthProblemException {
        String consumerKey = OAuthAuthenticationHandler.getParameter(message, "oauth_consumer_key");
        OAuthConsumer authConsumer = this.store.getConsumer(consumerKey);
        if (authConsumer == null) {
            throw new OAuthProblemException("consumer_key_unknown");
        }
        return authConsumer;
    }

    protected SecurityToken getTokenFromVerifiedRequest(OAuthMessage message, OAuthEntry entry, OAuthConsumer authConsumer) throws OAuthProblemException {
        if (entry != null) {
            return new OAuthSecurityToken(entry.userId, entry.callbackUrl, entry.appId, entry.domain, entry.container);
        }
        String userId = OAuthAuthenticationHandler.getParameter(message, REQUESTOR_ID_PARAM);
        return this.store.getSecurityTokenForConsumerRequest(authConsumer.consumerKey, userId);
    }

    public static byte[] readBody(HttpServletRequest request) throws IOException {
        if (request.getAttribute("STASHED_BODY") != null) {
            return (byte[])request.getAttribute("STASHED_BODY");
        }
        byte[] rawBody = IOUtils.toByteArray((InputStream)request.getInputStream());
        request.setAttribute("STASHED_BODY", (Object)rawBody);
        return rawBody;
    }

    public static String readBodyString(HttpServletRequest request) throws IOException {
        byte[] rawBody = OAuthAuthenticationHandler.readBody(request);
        return IOUtils.toString((InputStream)new ByteArrayInputStream(rawBody), (String)request.getCharacterEncoding());
    }

    public static void verifyBodyHash(HttpServletRequest request, String oauthBodyHash) throws AuthenticationHandler.InvalidAuthenticationException {
        if (request.getContentType() != null && request.getContentType().contains("application/x-www-form-urlencoded")) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Cannot use oauth_body_hash with a Content-Type of application/x-www-form-urlencoded", null);
        }
        try {
            byte[] rawBody = OAuthAuthenticationHandler.readBody(request);
            byte[] received = Base64.decodeBase64((byte[])CharsetUtil.getUtf8Bytes(oauthBodyHash));
            byte[] expected = DigestUtils.sha((byte[])rawBody);
            if (!Arrays.equals(received, expected)) {
                throw new AuthenticationHandler.InvalidAuthenticationException("oauth_body_hash failed verification", null);
            }
        }
        catch (IOException ioe) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Unable to read content body for oauth_body_hash verification", null);
        }
    }

    public static String getParameter(OAuthMessage requestMessage, String key) {
        try {
            return StringUtils.trim((String)requestMessage.getParameter(key));
        }
        catch (IOException e) {
            return null;
        }
    }
}

