/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.inject.Inject;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.uri.OAuthUriManager;

public class DefaultOAuthUriManager
implements OAuthUriManager {
    static final String OAUTH_GADGET_CALLBACK_URI_PARAM = "gadgets.uri.oauth.callbackTemplate";
    private final ContainerConfig config;

    @Inject
    public DefaultOAuthUriManager(ContainerConfig config) {
        this.config = config;
    }

    public Uri makeOAuthCallbackUri(String container, String host) {
        String callback = this.config.getString(container, OAUTH_GADGET_CALLBACK_URI_PARAM);
        if (callback == null) {
            return null;
        }
        return Uri.parse(callback.replace("%host%", host));
    }
}

