/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelinedData {
    private boolean needsViewer;
    private boolean needsOwner;
    private Map<String, BatchItemData> allPreloads;
    public static final String OPENSOCIAL_NAMESPACE = "http://ns.opensocial.org/2008/markup";
    public static final String EXTENSION_NAMESPACE = "http://ns.opensocial.org/2009/extensions";

    public PipelinedData(Element element, Uri base) throws SpecParserException {
        HashMap allPreloads = Maps.newHashMap();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (EXTENSION_NAMESPACE.equals(child.getNamespaceURI())) {
                if (!"Variable".equals(child.getLocalName())) continue;
                allPreloads.put(child.getAttribute("key"), this.createVariableRequest(child));
                continue;
            }
            if (!OPENSOCIAL_NAMESPACE.equals(child.getNamespaceURI())) continue;
            String elementName = child.getLocalName();
            String key = child.getAttribute("key");
            if (key == null) {
                throw new SpecParserException("Missing key attribute on os:" + elementName);
            }
            try {
                if ("PeopleRequest".equals(elementName)) {
                    allPreloads.put(key, this.createPeopleRequest(child));
                    continue;
                }
                if ("ViewerRequest".equals(elementName)) {
                    allPreloads.put(key, this.createViewerRequest(child));
                    continue;
                }
                if ("OwnerRequest".equals(elementName)) {
                    allPreloads.put(key, this.createOwnerRequest(child));
                    continue;
                }
                if ("PersonAppDataRequest".equals(elementName)) {
                    allPreloads.put(key, this.createPersonAppDataRequest(child));
                    continue;
                }
                if ("ActivitiesRequest".equals(elementName)) {
                    allPreloads.put(key, this.createActivityRequest(child));
                    continue;
                }
                if ("DataRequest".equals(elementName)) {
                    allPreloads.put(key, this.createDataRequest(child));
                    continue;
                }
                if ("HttpRequest".equals(elementName)) {
                    allPreloads.put(key, this.createHttpRequest(child, base));
                    continue;
                }
                throw new SpecParserException("Unknown element <os:" + elementName + '>');
            }
            catch (ELException ele) {
                throw new SpecParserException(new XmlException((Exception)((Object)ele)));
            }
        }
        this.allPreloads = Collections.unmodifiableMap(allPreloads);
    }

    private BatchItemData createVariableRequest(Element child) {
        return new VariableData(child.getAttribute("value"));
    }

    private PipelinedData(PipelinedData socialData, Substitutions substituter) {
        HashMap allPreloads = Maps.newHashMap();
        for (Map.Entry<String, BatchItemData> preload : socialData.allPreloads.entrySet()) {
            allPreloads.put(preload.getKey(), preload.getValue().substitute(substituter));
        }
        this.allPreloads = Collections.unmodifiableMap(allPreloads);
    }

    public PipelinedData substitute(Substitutions substituter) {
        return new PipelinedData(this, substituter);
    }

    public Batch getBatch(Expressions expressions, ELResolver rootObjects) {
        return this.getBatch(expressions, rootObjects, this.allPreloads);
    }

    private Batch getBatch(Expressions expressions, ELResolver rootObjects, Map<String, BatchItemData> currentPreloads) {
        ELContext elContext = expressions.newELContext(rootObjects);
        HashMap evaluatedPreloads = Maps.newHashMap();
        HashMap pendingPreloads = null;
        if (currentPreloads != null) {
            for (Map.Entry<String, BatchItemData> preload : currentPreloads.entrySet()) {
                try {
                    BatchItem value = preload.getValue().evaluate(expressions, elContext);
                    evaluatedPreloads.put(preload.getKey(), value);
                }
                catch (PropertyNotFoundException pe) {
                    if (pendingPreloads == null) {
                        pendingPreloads = Maps.newHashMap();
                    }
                    pendingPreloads.put(preload.getKey(), preload.getValue());
                }
                catch (ELException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (evaluatedPreloads.isEmpty() && pendingPreloads == null) {
            return null;
        }
        return new BatchImpl(expressions, evaluatedPreloads, pendingPreloads);
    }

    public boolean needsViewer() {
        return this.needsViewer;
    }

    public boolean needsOwner() {
        return this.needsOwner;
    }

    private SocialData createPeopleRequest(Element child) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "people.get");
        this.copyAttribute("groupId", child, expression, String.class);
        this.copyAttribute("userId", child, expression, JSONArray.class);
        this.updateUserArrayState("userId", child);
        this.copyAttribute("personId", child, expression, JSONArray.class);
        this.updateUserArrayState("personId", child);
        this.copyAttribute("startIndex", child, expression, Integer.class);
        this.copyAttribute("count", child, expression, Integer.class);
        this.copyAttribute("sortBy", child, expression, String.class);
        this.copyAttribute("sortOrder", child, expression, String.class);
        this.copyAttribute("filterBy", child, expression, String.class);
        this.copyAttribute("filterOperation", child, expression, String.class);
        this.copyAttribute("filterValue", child, expression, String.class);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createViewerRequest(Element child) throws ELException {
        return this.createPersonRequest(child, "@viewer");
    }

    private SocialData createOwnerRequest(Element child) throws ELException {
        return this.createPersonRequest(child, "@owner");
    }

    private SocialData createPersonRequest(Element child, String userId) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "people.get");
        expression.addProperty("userId", userId, JSONArray.class);
        this.updateUserState(userId);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createPersonAppDataRequest(Element child) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "appdata.get");
        this.copyAttribute("groupId", child, expression, String.class);
        this.copyAttribute("userId", child, expression, JSONArray.class);
        this.updateUserArrayState("userId", child);
        this.copyAttribute("appId", child, expression, String.class);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createActivityRequest(Element child) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "activities.get");
        this.copyAttribute("groupId", child, expression, String.class);
        this.copyAttribute("userId", child, expression, JSONArray.class);
        this.updateUserArrayState("userId", child);
        this.copyAttribute("appId", child, expression, String.class);
        this.copyAttribute("activityId", child, expression, JSONArray.class);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createDataRequest(Element child) throws ELException, SpecParserException {
        String method = child.getAttribute("method");
        if (method == null) {
            throw new SpecParserException("Missing @method attribute on os:DataRequest");
        }
        if (method.endsWith(".update") || method.endsWith(".create") || method.endsWith(".delete")) {
            throw new SpecParserException("Unsupported @method attribute \"" + method + "\" on os:DataRequest");
        }
        SocialData expression = new SocialData(child.getAttribute("key"), method);
        NamedNodeMap nodeMap = child.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String name;
            Node attrNode = nodeMap.item(i);
            if (attrNode.getNamespaceURI() != null || "method".equals(name = attrNode.getNodeName()) || "key".equals(name)) continue;
            String value = attrNode.getNodeValue();
            expression.addProperty(name, value, Object.class);
        }
        return expression;
    }

    private HttpData createHttpRequest(Element child, Uri base) throws ELException {
        HttpData data = new HttpData(child, base);
        if (data.authz != AuthType.NONE) {
            if (data.signOwner) {
                this.needsOwner = true;
            }
            if (data.signViewer) {
                this.needsViewer = true;
            }
        }
        return data;
    }

    private void copyAttribute(String name, Element element, SocialData expression, Class<?> type) throws ELException {
        if (element.hasAttribute(name)) {
            expression.addProperty(name, element.getAttribute(name), type);
        }
    }

    private void updateUserArrayState(String name, Element element) {
        if (element.hasAttribute(name)) {
            StringTokenizer tokens = new StringTokenizer(element.getAttribute(name), ",");
            while (tokens.hasMoreTokens()) {
                this.updateUserState(tokens.nextToken());
            }
        }
    }

    private void updateUserState(String userId) {
        if ("@owner".equals(userId)) {
            this.needsOwner = true;
        } else if ("@viewer".equals(userId) || "@me".equals(userId)) {
            this.needsViewer = true;
        }
    }

    private static class VariableData
    implements BatchItemData {
        private final String value;

        public VariableData(String value) {
            this.value = value;
        }

        public BatchItem evaluate(Expressions expressions, ELContext elContext) throws ELException {
            ValueExpression expression = expressions.parse(this.value, Object.class);
            final Object result = expression.getValue(elContext);
            return new BatchItem(){

                public Object getData() {
                    return result;
                }

                public BatchType getType() {
                    return BatchType.VARIABLE;
                }
            };
        }

        public BatchItemData substitute(Substitutions substituter) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SocialData
    implements BatchItemData {
        private final List<Property> properties = Lists.newArrayList();
        private final String id;
        private final String method;

        public SocialData(String id, String method) {
            this.id = id;
            this.method = method;
        }

        public void addProperty(String name, String value, Class<?> type) throws ELException {
            this.properties.add(new Property(name, value, type));
        }

        private JSONObject toJson(Expressions expressions, ELContext elContext) throws ELException {
            JSONObject object = new JSONObject();
            try {
                object.put("method", (Object)this.method);
                object.put("id", (Object)this.id);
                JSONObject params = new JSONObject();
                for (Property property : this.properties) {
                    property.set(expressions, elContext, params);
                }
                object.put("params", (Object)params);
            }
            catch (JSONException je) {
                throw new ELException((Throwable)je);
            }
            return object;
        }

        @Override
        public BatchItem evaluate(Expressions expressions, ELContext elContext) throws ELException {
            final JSONObject jsonResult = this.toJson(expressions, elContext);
            return new BatchItem(){

                public Object getData() {
                    return jsonResult;
                }

                public BatchType getType() {
                    return BatchType.SOCIAL;
                }
            };
        }

        @Override
        public BatchItemData substitute(Substitutions substituter) {
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Property {
            private final String name;
            private final String value;
            private final Class<?> type;

            public Property(String name, String value, Class<?> type) {
                this.name = name;
                this.value = value;
                this.type = type;
            }

            public void set(Expressions expressions, ELContext elContext, JSONObject object) throws ELException {
                ValueExpression expression = expressions.parse(this.value, this.type);
                Object value = expression.getValue(elContext);
                try {
                    if (value != null) {
                        object.put(this.name, value);
                    }
                }
                catch (JSONException e) {
                    throw new ELException("Error parsing property \"" + this.name + '\"', (Throwable)e);
                }
            }
        }
    }

    private static class HttpData
    implements BatchItemData {
        private final AuthType authz;
        private final Uri base;
        private final String href;
        private final boolean signOwner;
        private final boolean signViewer;
        private final Map<String, String> attributes;
        private static final Set<String> KNOWN_ATTRIBUTES = ImmutableSet.of((Object)"authz", (Object)"href", (Object)"sign_owner", (Object)"sign_viewer");

        public HttpData(Element element, Uri base) throws ELException {
            this.base = base;
            this.authz = element.hasAttribute("authz") ? AuthType.parse(element.getAttribute("authz")) : AuthType.NONE;
            this.href = element.getAttribute("href");
            this.signOwner = this.booleanValue(element, "sign_owner", true);
            this.signViewer = this.booleanValue(element, "sign_viewer", true);
            ImmutableMap.Builder attributes = ImmutableMap.builder();
            for (int i = 0; i < element.getAttributes().getLength(); ++i) {
                Node attr = element.getAttributes().item(i);
                if (KNOWN_ATTRIBUTES.contains(attr.getNodeName())) continue;
                attributes.put((Object)attr.getNodeName(), (Object)attr.getNodeValue());
            }
            this.attributes = attributes.build();
        }

        private HttpData(HttpData data, Substitutions substituter) {
            this.base = data.base;
            this.authz = data.authz;
            this.href = substituter.substituteString(data.href);
            this.signOwner = data.signOwner;
            this.signViewer = data.signViewer;
            this.attributes = data.attributes;
        }

        public HttpData substitute(Substitutions substituter) {
            return new HttpData(this, substituter);
        }

        public BatchItem evaluate(Expressions expressions, ELContext context) throws ELException {
            Uri evaluatedHref;
            String hrefString = String.valueOf(expressions.parse(this.href, String.class).getValue(context));
            try {
                evaluatedHref = this.base.resolve(Uri.parse(hrefString));
            }
            catch (IllegalArgumentException e) {
                throw new ELException("bad Uri '" + hrefString + "' - " + e.getMessage(), (Throwable)e);
            }
            final HashMap evaluatedAttributes = Maps.newHashMap();
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                ValueExpression expression = expressions.parse(attr.getValue(), String.class);
                evaluatedAttributes.put(attr.getKey(), String.valueOf(expression.getValue(context)));
            }
            final RequestAuthenticationInfo info = new RequestAuthenticationInfo(){

                @Override
                public Map<String, String> getAttributes() {
                    return evaluatedAttributes;
                }

                @Override
                public AuthType getAuthType() {
                    return HttpData.this.authz;
                }

                @Override
                public Uri getHref() {
                    return evaluatedHref;
                }

                @Override
                public boolean isSignOwner() {
                    return HttpData.this.signOwner;
                }

                @Override
                public boolean isSignViewer() {
                    return HttpData.this.signViewer;
                }
            };
            return new BatchItem(){

                public Object getData() {
                    return info;
                }

                public BatchType getType() {
                    return BatchType.HTTP;
                }
            };
        }

        private boolean booleanValue(Element element, String attrName, boolean defaultValue) {
            if (!element.hasAttribute(attrName)) {
                return defaultValue;
            }
            return "true".equalsIgnoreCase(element.getAttribute(attrName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BatchImpl
    implements Batch {
        private final Expressions expressions;
        private final Map<String, BatchItem> evaluatedPreloads;
        private final Map<String, BatchItemData> pendingPreloads;

        public BatchImpl(Expressions expressions, Map<String, BatchItem> evaluatedPreloads, Map<String, BatchItemData> pendingPreloads) {
            this.expressions = expressions;
            this.evaluatedPreloads = evaluatedPreloads;
            this.pendingPreloads = pendingPreloads;
        }

        @Override
        public Batch getNextBatch(ELResolver rootObjects) {
            return PipelinedData.this.getBatch(this.expressions, rootObjects, this.pendingPreloads);
        }

        @Override
        public Map<String, BatchItem> getPreloads() {
            return this.evaluatedPreloads;
        }
    }

    static interface BatchItemData {
        public BatchItem evaluate(Expressions var1, ELContext var2);

        public BatchItemData substitute(Substitutions var1);
    }

    public static interface BatchItem {
        public BatchType getType();

        public Object getData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchType {
        SOCIAL,
        HTTP,
        VARIABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Batch {
        public Map<String, BatchItem> getPreloads();

        public Batch getNextBatch(ELResolver var1);
    }
}

