/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.servlet.GadgetRenderingServlet;
import org.apache.shindig.gadgets.servlet.HttpGadgetContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAccelServlet
extends GadgetRenderingServlet {
    public static final String URL_PARAM_NAME = "url";
    public static final String ACCEL_GADGET_PARAM_NAME = "accelGadget";
    public static final String ACCEL_GADGET_PARAM_VALUE = "true";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String HTML_CONTENT = "text/html";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    private static final String FAKE_SPEC_TPL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Module>\n  <ModulePrefs title=\"Apache Shindig Accelerator\"\n               author=\"Apache Shindig\"\n               author_email=\"no-reply@gmail.com\">\n    <Require feature=\"core.none\"/>\n    <Optional feature=\"content-rewrite\">\n      <Param name=\"include-urls\">.*</Param>\n    </Optional>\n  </ModulePrefs>\n  <Content type=\"html\">\n    <![CDATA[%s]]>\n  </Content>\n</Module>\n";
    private RequestPipeline requestPipeline;
    private Map<String, String> addedServletParams = null;

    @Inject
    public void setRequestPipeline(RequestPipeline pipeline) {
        this.requestPipeline = pipeline;
    }

    @Inject(optional=true)
    public void setAddedServletParams(@Named(value="shindig.accelerate.added-params") Map<String, String> params) {
        this.addedServletParams = params;
    }

    public static boolean isAccel(GadgetContext context) {
        return context.getParameter(ACCEL_GADGET_PARAM_NAME) == ACCEL_GADGET_PARAM_VALUE;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpResponse data;
        HttpGadgetContext context = new HttpGadgetContext(req);
        try {
            data = this.fetch(context);
        }
        catch (GadgetException e) {
            resp.sendError(e.getHttpStatusCode(), e.getMessage());
            return;
        }
        if (data == null) {
            resp.sendError(400, "Error fetching data");
            return;
        }
        if (!this.isHtmlContent(data)) {
            this.respondVerbatim(data, resp);
            return;
        }
        String content = data.getResponseAsString();
        final String spec = this.createFakeSpec(content);
        HttpServletRequestWrapper reqWrapper = new HttpServletRequestWrapper(req){

            public String getParameter(String name) {
                if (name == HtmlAccelServlet.ACCEL_GADGET_PARAM_NAME) {
                    return HtmlAccelServlet.ACCEL_GADGET_PARAM_VALUE;
                }
                if (name == "rawxml") {
                    return spec;
                }
                if (HtmlAccelServlet.this.addedServletParams != null && HtmlAccelServlet.this.addedServletParams.containsKey(name)) {
                    return (String)HtmlAccelServlet.this.addedServletParams.get(name);
                }
                return super.getParameter(name);
            }
        };
        super.doGet((HttpServletRequest)reqWrapper, resp);
        if (data.getHttpStatusCode() == 500) {
            resp.setStatus(502);
        } else if (data.getHttpStatusCode() >= 400) {
            resp.setStatus(data.getHttpStatusCode());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    protected boolean isHtmlContent(HttpResponse data) {
        return data.getHeader(CONTENT_TYPE) != null && data.getHeader(CONTENT_TYPE).contains(HTML_CONTENT);
    }

    private HttpResponse fetch(HttpGadgetContext context) throws GadgetException {
        if (context.getUrl() == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Missing url paramater", 400);
        }
        HttpRequest request = new HttpRequest(context.getUrl()).setIgnoreCache(context.getIgnoreCache()).setContainer(context.getContainer());
        HttpResponse results = this.requestPipeline.execute(request);
        return results;
    }

    private void respondVerbatim(HttpResponse results, HttpServletResponse response) throws IOException {
        for (Map.Entry entry : results.getHeaders().entries()) {
            if (CONTENT_ENCODING.equals(entry.getKey()) || CONTENT_LENGTH.equals(entry.getKey())) continue;
            response.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        response.setStatus(results.getHttpStatusCode());
        if (results.getHttpStatusCode() == 500) {
            response.setStatus(502);
        }
        IOUtils.copy((InputStream)results.getResponse(), (OutputStream)response.getOutputStream());
    }

    private String createFakeSpec(String content) {
        String data = content.replace("]]>", "<![CDATA[").replace("<![CDATA[", "]]><![CDATA[");
        return String.format(FAKE_SPEC_TPL, data);
    }
}

