/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterUris;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

public class ProxyingLinkRewriter
implements LinkRewriter {
    protected final ContentRewriterUris rewriterUris;
    protected final ContentRewriterFeature rewriterFeature;
    protected final Uri gadgetUri;
    protected final String container;
    protected final boolean debug;
    protected final boolean ignoreCache;

    public ProxyingLinkRewriter(ContentRewriterUris rewriterUris, Uri gadgetUri, ContentRewriterFeature rewriterFeature, String container, boolean debug, boolean ignoreCache) {
        this.rewriterUris = rewriterUris;
        this.rewriterFeature = rewriterFeature;
        this.gadgetUri = gadgetUri;
        this.container = container;
        this.debug = debug;
        this.ignoreCache = ignoreCache;
    }

    public String rewrite(String link, Uri context) {
        String prefix = this.rewriterUris.getProxyBase(this.container);
        Uri parsedPrefix = Uri.parse(prefix);
        if ((link = link.trim()).length() == 0) {
            return link;
        }
        try {
            Uri linkUri = this.processLink(parsedPrefix, Uri.parse(link));
            Uri uri = context.resolve(linkUri);
            if (this.rewriterFeature.shouldRewriteURL(uri.toString())) {
                StringBuilder result = new StringBuilder();
                result.append(prefix);
                result.append(Utf8UrlCoder.encode(uri.toString()));
                result.append(this.gadgetUri == null ? "" : "&gadget=" + Utf8UrlCoder.encode(this.gadgetUri.toString()));
                result.append("&fp=");
                result.append(this.rewriterFeature.getFingerprint());
                if (this.debug) {
                    result.append("&debug=1");
                }
                if (this.ignoreCache) {
                    result.append("&nocache=1");
                }
                if (this.rewriterFeature.getExpires() != null) {
                    result.append('&').append("refresh").append('=').append(this.rewriterFeature.getExpires().toString());
                }
                return result.toString();
            }
            return uri.toString();
        }
        catch (IllegalArgumentException use) {
            return link;
        }
    }

    private Uri processLink(Uri parsedPrefix, Uri original) {
        if (parsedPrefix.getPath().equals(original.getPath())) {
            return Uri.parse(original.getQueryParameter("url"));
        }
        return original;
    }
}

