/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.LinkedList;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class CajaHtmlParser
extends GadgetHtmlParser {
    @Inject
    public CajaHtmlParser(DOMImplementation documentFactory) {
        super(documentFactory);
    }

    protected Document parseDomImpl(String source) throws GadgetException {
        DocumentFragment fragment = this.parseFragmentImpl(source);
        Document document = fragment.getOwnerDocument();
        Node html = null;
        LinkedList beforeHtml = Lists.newLinkedList();
        while (fragment.hasChildNodes()) {
            Node child = fragment.removeChild(fragment.getFirstChild());
            if (child.getNodeType() == 1 && "html".equalsIgnoreCase(child.getNodeName())) {
                if (html == null) {
                    html = child;
                    continue;
                }
                this.transferChildren(html, child);
                continue;
            }
            if (html != null) {
                html.appendChild(child);
                continue;
            }
            beforeHtml.add(child);
        }
        if (html == null) {
            html = document.createElement("html");
        }
        this.prependToNode(html, beforeHtml);
        document.appendChild(html);
        return document;
    }

    protected DocumentFragment parseFragmentImpl(String source) throws GadgetException {
        try {
            MessageQueue mq = this.makeMessageQueue();
            DomParser parser = this.getDomParser(source, mq);
            DocumentFragment fragment = parser.parseFragment();
            if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
                StringBuilder err = new StringBuilder();
                for (Message m : mq.getMessages()) {
                    err.append(m.toString()).append("\n");
                }
                throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, err.toString(), 400);
            }
            return fragment;
        }
        catch (ParseException e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, e.getCajaMessage().toString(), 400);
        }
    }

    protected InputSource getInputSource() {
        return InputSource.UNKNOWN;
    }

    protected MessageQueue makeMessageQueue() {
        return new SimpleMessageQueue();
    }

    protected boolean needsDebugData() {
        return false;
    }

    private DomParser getDomParser(String source, MessageQueue mq) throws ParseException {
        InputSource is = this.getInputSource();
        HtmlLexer lexer = new HtmlLexer(CharProducer.Factory.fromString((CharSequence)source, (InputSource)is));
        Namespaces ns = Namespaces.HTML_DEFAULT;
        boolean needsDebugData = this.needsDebugData();
        DomParser parser = new DomParser(lexer, is, ns, mq);
        parser.setDomImpl(this.documentFactory);
        parser.setWantsComments(true);
        parser.setNeedsDebugData(needsDebugData);
        return parser;
    }
}

