/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.AssociateAddressResult;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2InstanceManager {
    private static final Log log = LogFactory.getLog(EC2InstanceManager.class);
    private AmazonEC2 ec2;

    public EC2InstanceManager(AmazonEC2 ec2) {
        this.ec2 = ec2;
    }

    public List<String> runInstances(RunInstancesRequest request) {
        ArrayList<String> instanceIdList = new ArrayList<String>();
        try {
            RunInstancesResult result = this.ec2.runInstances(request);
            Reservation reservation = result.getReservation();
            log.info((Object)("Started instances. ReservationID:" + reservation.getReservationId()));
            List instances = reservation.getInstances();
            for (Instance instance : instances) {
                log.info((Object)("Starting instance " + instance.getInstanceId()));
                instanceIdList.add(instance.getInstanceId());
            }
        }
        catch (AmazonClientException e) {
            this.handleException(e);
        }
        return instanceIdList;
    }

    public void terminateInstances(List<String> instanceIds) throws AmazonClientException {
        try {
            TerminateInstancesRequest request = new TerminateInstancesRequest(instanceIds);
            TerminateInstancesResult result = this.ec2.terminateInstances(request);
            List terminatingInstances = result.getTerminatingInstances();
            for (InstanceStateChange terminatingInstance : terminatingInstances) {
                log.info((Object)("Terminated instance " + terminatingInstance.getInstanceId()));
            }
        }
        catch (AmazonClientException e) {
            this.handleException(e);
        }
    }

    public List<Reservation> describeInstances() throws AmazonClientException {
        try {
            DescribeInstancesResult result = this.ec2.describeInstances();
            return result.getReservations();
        }
        catch (AmazonClientException e) {
            this.handleException(e);
            return new ArrayList<Reservation>();
        }
    }

    public List<Address> describeAddresses(List<String> elasticIps) throws AmazonClientException {
        try {
            DescribeAddressesRequest request = new DescribeAddressesRequest();
            request.setPublicIps(elasticIps);
            DescribeAddressesResult result = this.ec2.describeAddresses(request);
            return result.getAddresses();
        }
        catch (AmazonClientException e) {
            this.handleException(e);
            return new ArrayList<Address>();
        }
    }

    public Address describeAddress(String elasticIp) throws AmazonClientException {
        try {
            DescribeAddressesRequest request = new DescribeAddressesRequest();
            request.setPublicIps(Arrays.asList(elasticIp));
            DescribeAddressesResult result = this.ec2.describeAddresses(request);
            return (Address)result.getAddresses().get(0);
        }
        catch (AmazonClientException e) {
            this.handleException(e);
            return null;
        }
    }

    public void associateAddress(String instanceId, String elasticIP) throws AmazonClientException {
        try {
            AssociateAddressRequest request = new AssociateAddressRequest();
            request.setInstanceId(instanceId);
            request.setPublicIp(elasticIP);
            AssociateAddressResult result = this.ec2.associateAddress(request);
            log.info((Object)("Associated instance " + instanceId + " with elastic IP " + elasticIP + ". AssociationID:" + result.getAssociationId()));
        }
        catch (AmazonClientException e) {
            this.handleException(e);
        }
    }

    public Instance describeInstance(String instanceId) {
        if (instanceId == null || instanceId.isEmpty()) {
            return null;
        }
        try {
            DescribeInstancesRequest request = new DescribeInstancesRequest();
            request.withInstanceIds(new String[]{instanceId});
            DescribeInstancesResult result = this.ec2.describeInstances(request);
            List reservations = result.getReservations();
            if (reservations != null && !reservations.isEmpty()) {
                return (Instance)((Reservation)reservations.get(0)).getInstances().get(0);
            }
        }
        catch (AmazonClientException e) {
            this.handleException(e);
        }
        return null;
    }

    public void setInstanceAttribute(String instanceId, String name, String value) {
        ModifyInstanceAttributeRequest request = new ModifyInstanceAttributeRequest();
        request.setAttribute(name);
        request.setValue(value);
        request.setInstanceId(instanceId);
        try {
            this.ec2.modifyInstanceAttribute(request);
        }
        catch (AmazonClientException e) {
            this.handleException(e);
        }
    }

    public void enableApiTermination(String instanceId) {
        this.setInstanceAttribute(instanceId, "disableApiTermination", "false");
    }

    private void handleException(AmazonClientException e) throws AmazonClientException {
        if (!e.getMessage().toLowerCase().contains("Request Limit exceeded")) {
            throw e;
        }
        log.debug((Object)"EC2 Request limit exceeded", (Throwable)e);
    }
}

