/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.wso2.carbon.lb.common.dao.AbstractDAO;
import org.wso2.carbon.lb.common.dto.Bridge;
import org.wso2.carbon.lb.common.dto.HostMachine;

public class HostMachineDAO
extends AbstractDAO {
    private Connection con = null;
    private String url = "jdbc:mysql://localhost:3306/";
    private String db = "hosting_mgt_db";
    private String driver = "com.mysql.jdbc.Driver";
    private String dbUsername = "root";
    private String dbPassword = "root";
    private Statement statement = null;

    public boolean create(HostMachine hostMachine, String[] domains) throws SQLException {
        boolean successfullyAdded = false;
        try {
            Bridge[] bridges;
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "INSERT INTO host_machine VALUES('" + hostMachine.getEpr() + "','" + hostMachine.getIp() + "'," + hostMachine.isAvailable() + ",'" + hostMachine.getContainerRoot() + "','" + hostMachine.getZone() + "')";
            this.statement.executeUpdate(sql);
            for (Bridge bridge : bridges = hostMachine.getBridges()) {
                String sqlForBridge = "INSERT INTO bridge VALUES(" + bridge.isAvailable() + ",'" + bridge.getHostMachine() + "'," + bridge.getMaximumCountIps() + "," + bridge.getCurrentCountIps() + ",'" + bridge.getBridgeIp() + "','" + bridge.getNetMask() + "','" + bridge.getNetGateway() + "')";
                this.statement.executeUpdate(sqlForBridge);
                String sqlForStartingIp = "INSERT INTO available_ip (ip, bridge) VALUES('" + this.incrementIp(bridge.getBridgeIp()) + "','" + bridge.getBridgeIp() + "')";
                this.statement.executeUpdate(sqlForStartingIp);
            }
            successfullyAdded = true;
        }
        catch (SQLException s) {
            String msg = "Error while inserting host machine data" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return successfullyAdded;
    }

    public void changeAvailability(String endPoint, boolean availability) throws SQLException {
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "UPDATE host_machine SET available=false WHERE epr='" + endPoint + "'";
            this.statement.executeUpdate(sql);
        }
        catch (SQLException s) {
            String msg = "Error while deleting container data" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isHostMachineExist(String endPoint) throws SQLException {
        boolean isExist = false;
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT available FROM host_machine WHERE epr='" + endPoint + "'";
            resultSet = this.statement.executeQuery(sql);
            if (resultSet.next()) {
                isExist = resultSet.getBoolean("available");
            }
        }
        catch (SQLException s) {
            String msg = "SQL statement is not executed for host machine exist !";
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "DB connection not successful !";
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return isExist;
    }

    public boolean isAvailableInDomain(String domain) throws SQLException {
        boolean isAvailable = false;
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT zone FROM domain WHERE domain_name='" + domain + "'";
            resultSet = this.statement.executeQuery(sql);
            if (resultSet.next()) {
                String zone = resultSet.getString("zone");
                sql = "SELECT available FROM host_machine WHERE zone='" + zone + "'";
                resultSet = this.statement.executeQuery(sql);
                if (resultSet.next()) {
                    isAvailable = resultSet.getBoolean("available");
                }
            }
        }
        catch (SQLException s) {
            String msg = "SQL statement is not executed for host machine exist !";
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "DB connection not successful !";
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return isAvailable;
    }

    public boolean delete(String epr) throws SQLException {
        boolean successfullyDeleted = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "DELETE FROM host_machine WHERE epr='" + epr + "'";
            this.statement.executeUpdate(sql);
            successfullyDeleted = true;
        }
        catch (SQLException s) {
            String msg = "Error while deleting host machine data " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return successfullyDeleted;
    }

    public HashMap<String, String> getContainerIdToAgentMap() throws SQLException {
        HashMap<String, String> containerToAgentMap = new HashMap<String, String>();
        ResultSet resultSetForContainer = null;
        ResultSet resultSetForBridge = null;
        Statement statementForBridge = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT container_id, bridge FROM container";
            resultSetForContainer = this.statement.executeQuery(sql);
            while (resultSetForContainer.next()) {
                String containerId = resultSetForContainer.getString("container_id");
                String bridgeIp = resultSetForContainer.getString("bridge");
                statementForBridge = this.con.createStatement();
                sql = "SELECT host_machine FROM bridge WHERE bridge_ip='" + bridgeIp + "'";
                resultSetForBridge = statementForBridge.executeQuery(sql);
                String hostMachineEpr = null;
                if (resultSetForBridge.next()) {
                    hostMachineEpr = resultSetForBridge.getString("host_machine");
                }
                containerToAgentMap.put(containerId, hostMachineEpr);
            }
        }
        catch (SQLException s) {
            String msg = "Error while getting container id to agent map " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSetForBridge != null) {
                    resultSetForBridge.close();
                }
            }
            catch (Exception e) {}
            try {
                if (resultSetForContainer != null) {
                    resultSetForContainer.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return containerToAgentMap;
    }

    public HashMap<String, String> getAgentToContainerRootMap() throws SQLException {
        HashMap<String, String> eprToContainerRootMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT epr, container_root FROM host_machine";
            resultSet = this.statement.executeQuery(sql);
            while (resultSet.next()) {
                String epr = resultSet.getString("epr");
                String containerRoot = resultSet.getString("container_root");
                eprToContainerRootMap.put(epr, containerRoot);
            }
        }
        catch (SQLException s) {
            String msg = "Error while getting container id to agent map " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return eprToContainerRootMap;
    }
}

