/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.wso2.carbon.lb.common.dao.AbstractDAO;
import org.wso2.carbon.lb.common.dto.Bridge;
import org.wso2.carbon.lb.common.dto.Container;
import org.wso2.carbon.lb.common.dto.ContainerInformation;
import org.wso2.carbon.lb.common.dto.HostMachine;

public class ContainerDAO
extends AbstractDAO {
    private Connection con = null;
    private String url = "jdbc:mysql://localhost:3306/";
    private String db = "hosting_mgt_db";
    private String driver = "com.mysql.jdbc.Driver";
    private String dbUsername = "root";
    private String dbPassword = "root";
    private Statement statement = null;

    public void create(Container container) throws SQLException {
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "INSERT INTO container VALUES('" + container.getContainerId() + "','" + container.getType() + "','" + container.getLabel() + "','" + container.getDescription() + "'," + container.isStarted() + ",'" + container.getTenant() + "','" + container.getContainerKeysFile() + "','" + container.getTemplate() + "','" + container.getIp() + "','" + container.getBridge() + "')";
            this.statement.executeUpdate(sql);
        }
        catch (SQLException s) {
            String msg = "Error while inserting container data" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg, s);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void delete(String containerId) throws SQLException {
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "DELETE FROM container WHERE container_id='" + containerId + "'";
            this.statement.executeUpdate(sql);
        }
        catch (SQLException s) {
            String msg = "Error while deleting container data" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void changeState(String containerId, Boolean status) throws SQLException {
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "UPDATE container SET started=" + status + " WHERE container_id='" + containerId + "'";
            this.statement.executeUpdate(sql);
        }
        catch (SQLException s) {
            String msg = "Error while deleting container data" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private HostMachine getAvailableHostMachine(String domain) throws SQLException {
        HostMachine hostMachine = new HostMachine();
        ResultSet resultSetForHM = null;
        Statement statementForBridge = null;
        Statement statementForContainer = null;
        ResultSet resultSetForBridge = null;
        ResultSet resultSetForContainer = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sqlDomain = "SELECT zone FROM domain WHERE domain_name='" + domain + "'";
            resultSetForHM = this.statement.executeQuery(sqlDomain);
            resultSetForHM.next();
            String zone = resultSetForHM.getString("zone");
            String sql = "SELECT * FROM host_machine WHERE zone='" + zone + "' AND available=true";
            resultSetForHM = this.statement.executeQuery(sql);
            int minimumContainerCountHM = -1;
            while (resultSetForHM.next()) {
                int containerCountOfHostMachine = 0;
                String hostMachineEndPoint = resultSetForHM.getString("epr");
                Bridge[] bridges = new Bridge[]{new Bridge()};
                statementForBridge = this.con.createStatement();
                sql = "SELECT * FROM bridge WHERE host_machine='" + hostMachineEndPoint + "' AND available=true";
                resultSetForBridge = statementForBridge.executeQuery(sql);
                int minimumContainerCountBridge = -1;
                while (resultSetForBridge.next()) {
                    statementForContainer = this.con.createStatement();
                    sql = "SELECT COUNT(bridge) FROM container WHERE bridge='" + resultSetForBridge.getString("bridge_ip") + "'";
                    resultSetForContainer = statementForContainer.executeQuery(sql);
                    resultSetForContainer.next();
                    int containerCount = resultSetForContainer.getInt(1);
                    containerCountOfHostMachine += containerCount;
                    if (minimumContainerCountBridge != -1 && minimumContainerCountBridge <= containerCount) continue;
                    minimumContainerCountBridge = containerCount;
                    bridges[0].setBridgeIp(resultSetForBridge.getString("bridge_ip"));
                    bridges[0].setNetGateway(resultSetForBridge.getString("net_gateway"));
                    bridges[0].setNetMask(resultSetForBridge.getString("net_mask"));
                }
                if (minimumContainerCountHM != -1 && minimumContainerCountHM <= containerCountOfHostMachine) continue;
                minimumContainerCountHM = containerCountOfHostMachine;
                hostMachine.setEpr(hostMachineEndPoint);
                hostMachine.setContainerRoot(resultSetForHM.getString("container_root"));
                hostMachine.setAvailable(true);
                hostMachine.setIp(resultSetForHM.getString("ip"));
                hostMachine.setZone(zone);
                hostMachine.setBridges(bridges);
            }
        }
        catch (SQLException s) {
            String msg = "Error while retrieving container data" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSetForContainer != null) {
                    resultSetForContainer.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (resultSetForBridge != null) {
                    resultSetForBridge.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (resultSetForHM != null) {
                    resultSetForHM.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (statementForBridge != null) {
                    statementForBridge.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (statementForContainer != null) {
                    statementForContainer.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return hostMachine;
    }

    private String getAvailableIp(String bridgeIp) throws SQLException {
        String availableIp = null;
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT * FROM available_ip WHERE bridge='" + bridgeIp + "'";
            resultSet = this.statement.executeQuery(sql);
            int ipCount = 0;
            while (resultSet.next()) {
                availableIp = resultSet.getString("ip").trim();
                if (++ipCount != 2) continue;
                sql = "DELETE FROM available_ip WHERE ip='" + availableIp + "'";
                this.statement.executeUpdate(sql);
                break;
            }
            if (ipCount == 1) {
                sql = "UPDATE available_ip SET ip='" + this.incrementIp(availableIp) + "' WHERE ip='" + availableIp + "'";
                this.statement.executeUpdate(sql);
            }
        }
        catch (SQLException s) {
            String msg = "Error while getting available ip " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return availableIp;
    }

    public ContainerInformation retrieveAvailableContainerInformation(String domain) throws SQLException {
        ContainerInformation containerInformation = new ContainerInformation();
        HostMachine hostMachine = this.getAvailableHostMachine(domain);
        containerInformation.setEpr(hostMachine.getEpr());
        Bridge[] bridges = hostMachine.getBridges();
        containerInformation.setContainerRoot(hostMachine.getContainerRoot());
        String bridgeIp = bridges[0].getBridgeIp();
        containerInformation.setBridge(bridgeIp);
        containerInformation.setIp(this.getAvailableIp(bridgeIp));
        containerInformation.setNetGateway(bridges[0].getNetGateway());
        containerInformation.setNetMask(bridges[0].getNetMask());
        containerInformation.setType("S");
        return containerInformation;
    }
}

