/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.conf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import sun.misc.BASE64Encoder;

public final class LoadBalancerConfigUtil {
    private static final Log log = LogFactory.getLog(LoadBalancerConfigUtil.class);

    private LoadBalancerConfigUtil() {
    }

    public static void handleException(String msg) {
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    public static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    public static String replaceVariables(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = text.indexOf("${");
        if (indexOfStartingChars != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String var = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(var);
            if (propValue == null) {
                propValue = System.getenv(var);
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
        }
        return text;
    }

    public static String getUserData(String payloadFileName) {
        String userData = null;
        try {
            byte[] bytes;
            File file = new File(payloadFileName);
            if (!file.exists()) {
                LoadBalancerConfigUtil.handleException("Payload file " + payloadFileName + " does not exist");
            }
            if (!file.canRead()) {
                LoadBalancerConfigUtil.handleException("Payload file " + payloadFileName + " does cannot be read");
            }
            if ((bytes = LoadBalancerConfigUtil.getBytesFromFile(file)) != null) {
                BASE64Encoder encoder = new BASE64Encoder();
                userData = encoder.encode(bytes);
            }
        }
        catch (Exception e) {
            LoadBalancerConfigUtil.handleException("Cannot read data from payload file " + payloadFileName, e);
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        if (!file.exists()) {
            log.error((Object)("Payload file " + file.getAbsolutePath() + " does not exist"));
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            int offset;
            int numRead;
            long length = file.length();
            if (length > Integer.MAX_VALUE && log.isDebugEnabled()) {
                log.debug((Object)"File is too large");
            }
            bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }
}

