/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.conf.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node
implements Serializable {
    private static final long serialVersionUID = 4071569903421115370L;
    private String name;
    private List<Node> childNodes = new ArrayList<Node>();
    private Map<String, String> properties = new HashMap<String, String>();

    public String childNodesToString() {
        StringBuilder childNodesString = new StringBuilder();
        for (Node node : this.childNodes) {
            childNodesString.append(node.toString() + "\n");
        }
        return childNodesString.toString();
    }

    public Node findChildNodeByName(String name) {
        for (Node aNode : this.childNodes) {
            if (!aNode.getName().equals(name)) continue;
            return aNode;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<Node> getChildNodes() {
        return this.childNodes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        if (this.properties.get(key) == null) {
            return null;
        }
        return this.properties.get(key).trim();
    }

    public String propertiesToString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            sb.append(entry.getKey() + "\t" + entry.getValue() + ";\n");
        }
        return sb.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void appendChild(Node aNode) {
        if (aNode != null) {
            this.childNodes.add(aNode);
        }
    }

    public void addProperty(String key, String value) {
        if (key != null) {
            this.properties.put(key, value);
        }
    }

    public String toString() {
        String nodeString = this.getName() + " {\n" + this.propertiesToString() + this.childNodesToString() + "}";
        return nodeString;
    }
}

