/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.conf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.synapse.commons.util.PropertyHelper;
import org.wso2.carbon.lb.common.conf.structure.Node;
import org.wso2.carbon.lb.common.conf.structure.NodeBuilder;
import org.wso2.carbon.lb.common.conf.util.LoadBalancerConfigUtil;
import org.wso2.carbon.lb.common.conf.util.TenantDomainRangeContext;

public class LoadBalancerConfiguration
implements Serializable {
    protected static final long serialVersionUID = -5553545217542808233L;
    protected Map<String, ServiceConfiguration> serviceConfigMap = new HashMap<String, ServiceConfiguration>();
    private Map<String, TenantDomainRangeContext> hostDomainMap;
    protected Map<String, Node> serviceToDomainsMap = new HashMap<String, Node>();
    protected Map<String, Node> hostDomainNodeMap = new HashMap<String, Node>();
    protected ServiceConfiguration defaultServiceConfig;
    protected LBConfiguration lbConfig;
    protected String lbConfigString;
    protected Node rootNode;

    public Map<String, TenantDomainRangeContext> getHostDomainMap() {
        return this.hostDomainMap;
    }

    public void setHostDomainMap(Map<String, TenantDomainRangeContext> hostDomainMap) {
        this.hostDomainMap = hostDomainMap;
    }

    public Map<String, Node> getServiceToDomainsMap() {
        return this.serviceToDomainsMap;
    }

    public Map<String, Node> getHostDomainNodeMap() {
        return this.hostDomainNodeMap;
    }

    public void init(String configURL) {
        if (configURL.startsWith("$system:")) {
            configURL = System.getProperty(configURL.substring("$system:".length()));
        }
        try {
            this.lbConfigString = configURL.startsWith(File.separator) ? this.createLBConfigString(configURL) : this.createLBConfigString(new URL(configURL).openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read configuration file from " + configURL);
        }
        this.rootNode = new Node();
        this.rootNode.setName("root");
        this.rootNode = NodeBuilder.buildNode(this.rootNode, this.lbConfigString);
        Node lbConfigNode = this.rootNode.findChildNodeByName("loadbalancer");
        if (lbConfigNode == null) {
            throw new RuntimeException("Mandatory loadbalancer element can not be found in configuration file.");
        }
        this.lbConfig = new LBConfiguration();
        this.createConfiguration(this.lbConfig, lbConfigNode);
        Node servicesConfigNode = this.rootNode.findChildNodeByName("services");
        if (servicesConfigNode == null) {
            throw new RuntimeException("Mandatory services element can not be found in configuration file.");
        }
        this.createServicesConfig(servicesConfigNode);
        this.setHostDomainMap(this.loadHostDomainMap());
    }

    public String getDomain(String host, int tenantId) {
        if (this.hostDomainNodeMap.containsKey(host)) {
            for (Node aNode : this.hostDomainNodeMap.get(host).getChildNodes()) {
                String tenantRange = aNode.getProperty("tenant_range");
                if (tenantRange == null || "".equals(tenantRange)) {
                    throw new RuntimeException("Mandatory element tenant_range which is a child element of " + aNode.getName() + " cannot be found.");
                }
                if (tenantRange.equals("*")) {
                    return aNode.getName();
                }
                String[] limits = tenantRange.split("-");
                if (limits.length != 2) {
                    throw new RuntimeException("Malformed element tenant_range which is a child element of " + aNode.getName());
                }
                int lowerLimit = Integer.parseInt(limits[0]);
                int upperLimit = Integer.parseInt(limits[1]);
                if (tenantId < lowerLimit || tenantId > upperLimit) continue;
                return aNode.getName();
            }
        }
        return "";
    }

    public Map<String, String> getdomainToTenantRangeMap(Node domains) {
        HashMap<String, String> domainToTenantRangeMap = new HashMap<String, String>();
        for (Node domain : domains.getChildNodes()) {
            String domainName = domain.getName();
            String tenantRange = domain.getProperty("tenant_range");
            if (tenantRange == null || "".equals(tenantRange)) {
                throw new RuntimeException("Mandatory element tenant_range which is a child element of " + domain.getName() + " cannot be found.");
            }
            if (tenantRange == null || "".equals(tenantRange) || domainName == null || "".equals(domainName)) continue;
            domainToTenantRangeMap.put(domainName, tenantRange);
        }
        return domainToTenantRangeMap;
    }

    public void createServicesConfig(Node servicesConfigNode) {
        if (servicesConfigNode == null) {
            throw new RuntimeException("Mandatory services element can not be found in configuration file.");
        }
        Node defaultNode = servicesConfigNode.findChildNodeByName("defaults");
        this.defaultServiceConfig = new ServiceConfiguration(null);
        this.createConfiguration(this.defaultServiceConfig, defaultNode);
        for (Node serviceNode : servicesConfigNode.getChildNodes()) {
            String[] host;
            Node domainsNode;
            if (serviceNode == defaultNode) continue;
            String serviceName = serviceNode.getName();
            if (serviceNode.getChildNodes().isEmpty() || !(domainsNode = serviceNode.getChildNodes().get(0)).getName().equals("domains")) {
                throw new RuntimeException("The mandatory domains element child of the " + serviceName + " element is not specified");
            }
            if (domainsNode.getChildNodes().isEmpty()) {
                throw new RuntimeException("No domain is specified under domains of " + serviceName + " element.");
            }
            String hosts = serviceNode.getProperty("hosts");
            if (hosts == null) {
                throw new RuntimeException("The mandatory hosts element, which is a child of " + serviceName + " element is not specified");
            }
            for (String aHost : host = hosts.split(",")) {
                if (aHost.isEmpty()) {
                    throw new RuntimeException("host cannot be empty");
                }
                if (this.hostDomainNodeMap.containsKey(aHost)) {
                    throw new RuntimeException("host " + aHost + " has been duplicated in the configuration");
                }
                this.hostDomainNodeMap.put(aHost.trim(), domainsNode);
            }
            this.serviceToDomainsMap.put(serviceName, domainsNode);
            for (Node domain : domainsNode.getChildNodes()) {
                ServiceConfiguration serviceConfig = new ServiceConfiguration(domain.getName());
                this.createConfiguration(serviceConfig, serviceNode);
                this.createConfiguration(serviceConfig, domain);
                this.serviceConfigMap.put(domain.getName(), serviceConfig);
            }
        }
    }

    public Map<String, TenantDomainRangeContext> loadHostDomainMap() {
        HashMap<String, TenantDomainRangeContext> map = new HashMap<String, TenantDomainRangeContext>();
        for (Map.Entry<String, Node> entry : this.getServiceToDomainsMap().entrySet()) {
            Node domains = entry.getValue();
            TenantDomainRangeContext domainRangeContext = new TenantDomainRangeContext();
            for (Map.Entry<String, String> entry2 : this.getdomainToTenantRangeMap(domains).entrySet()) {
                String domainName = entry2.getKey();
                String tenantRange = entry2.getValue();
                domainRangeContext.addTenantDomain(domainName, tenantRange);
            }
            for (Map.Entry<String, Object> entry3 : this.getHostDomainNodeMap().entrySet()) {
                String host = entry3.getKey();
                Node domainsNode = (Node)entry3.getValue();
                if (!domainsNode.equals(domains)) continue;
                map.put(host, domainRangeContext);
            }
        }
        return map;
    }

    protected void createConfiguration(Configuration config, Node node) {
        if (node == null) {
            throw new RuntimeException("The configuration element for " + config.getClass().getName() + " is null");
        }
        try {
            for (Map.Entry<String, String> entry : node.getProperties().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                PropertyHelper.setInstanceProperty((String)key, (Object)value, (Object)config);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting values to " + config.getClass().getName(), e);
        }
    }

    public LBConfiguration getLoadBalancerConfig() {
        return this.lbConfig;
    }

    public String[] getServiceDomains() {
        Set<String> domains = this.serviceConfigMap.keySet();
        return domains.toArray(new String[domains.size()]);
    }

    public ServiceConfiguration getServiceConfig(String domain) {
        return this.serviceConfigMap.get(domain);
    }

    public String createLBConfigString(String configFileName) throws FileNotFoundException {
        StringBuilder lbConfigString = new StringBuilder("");
        File configFile = new File(configFileName);
        Scanner scanner = new Scanner(configFile);
        while (scanner.hasNextLine()) {
            lbConfigString.append(scanner.nextLine().trim() + "\n");
        }
        return lbConfigString.toString().trim();
    }

    public String createLBConfigString(InputStream configFileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(configFileName));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line.trim() + "\n");
        }
        return sb.toString().trim();
    }

    public class ServiceConfiguration
    extends Configuration
    implements Serializable {
        private int minAppInstances;
        private boolean minAppInstancesSet;
        private int maxAppInstances;
        private boolean maxAppInstancesSet;
        private int queueLengthPerNode;
        private boolean queueLengthPerNodeSet;
        private int roundsToAverage;
        private boolean roundsToAverageSet;
        private int instancesPerScaleUp;
        private boolean instancesPerScaleUpSet;
        private int messageExpiryTime;
        private boolean messageExpiryTimeSet;
        private String hosts;
        private String domain;
        private String tenantRange;
        private String subDomain;
        private boolean subDomainSet;

        public ServiceConfiguration(String domain) {
            this.minAppInstances = 1;
            this.maxAppInstances = 3;
            this.queueLengthPerNode = 4;
            this.roundsToAverage = 10;
            this.instancesPerScaleUp = 1;
            this.messageExpiryTime = 60000;
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getHosts() {
            return this.hosts;
        }

        public int getMinAppInstances() {
            if (this.minAppInstancesSet) {
                return this.minAppInstances;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.minAppInstancesSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.minAppInstances;
            }
            return this.minAppInstances;
        }

        public int getMaxAppInstances() {
            if (this.maxAppInstancesSet) {
                return this.maxAppInstances;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.maxAppInstancesSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.maxAppInstances;
            }
            return this.maxAppInstances;
        }

        public int getQueueLengthPerNode() {
            if (this.queueLengthPerNodeSet) {
                return this.queueLengthPerNode;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.queueLengthPerNodeSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.queueLengthPerNode;
            }
            return this.queueLengthPerNode;
        }

        public int getRoundsToAverage() {
            if (this.roundsToAverageSet) {
                return this.roundsToAverage;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.roundsToAverageSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.roundsToAverage;
            }
            return this.roundsToAverage;
        }

        public int getInstancesPerScaleUp() {
            if (this.instancesPerScaleUpSet) {
                return this.instancesPerScaleUp;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.instancesPerScaleUpSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.instancesPerScaleUp;
            }
            return this.instancesPerScaleUp;
        }

        public int getMessageExpiryTime() {
            if (this.messageExpiryTimeSet) {
                return this.messageExpiryTime;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.messageExpiryTimeSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.messageExpiryTime;
            }
            return this.messageExpiryTime;
        }

        public String getSubDomain() {
            if (this.subDomainSet) {
                return this.subDomain;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.subDomainSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.subDomain;
            }
            return this.subDomain;
        }

        public void setMin_app_instances(int minAppInstances) {
            if (minAppInstances < 1) {
                LoadBalancerConfigUtil.handleException("minAppInstances in the autoscaler task configuration should be at least 1");
            }
            this.minAppInstances = minAppInstances;
            this.minAppInstancesSet = true;
        }

        public void setMax_app_instances(int maxAppInstances) {
            if (maxAppInstances < 1) {
                LoadBalancerConfigUtil.handleException("maxAppInstances in the autoscaler task configuration should be at least 1");
            }
            this.maxAppInstances = maxAppInstances;
            this.maxAppInstancesSet = true;
        }

        public void setQueue_length_per_node(int queueLengthPerNode) {
            this.queueLengthPerNode = queueLengthPerNode;
            this.queueLengthPerNodeSet = true;
        }

        public void setRounds_to_average(int roundsToAverage) {
            this.roundsToAverage = roundsToAverage;
            this.roundsToAverageSet = true;
        }

        public void setInstances_per_scale_up(int instancesPerScaleUp) {
            if (instancesPerScaleUp < 1) {
                LoadBalancerConfigUtil.handleException("instancesPerScaleUp in the autoscaler task configuration should be at least 1");
            }
            this.instancesPerScaleUp = instancesPerScaleUp;
            this.instancesPerScaleUpSet = true;
        }

        public void setMessage_expiry_time(int messageExpiryTime) {
            if (messageExpiryTime < 1) {
                LoadBalancerConfigUtil.handleException("messageExpiryTime in the autoscaler task configuration should be at least 1");
            }
            this.messageExpiryTime = messageExpiryTime;
            this.messageExpiryTimeSet = true;
        }

        public void setHosts(String hosts) {
            this.hosts = hosts;
        }

        public void setTenant_range(String range) {
            this.tenantRange = range;
        }

        public void setSub_domain(String subDomain) {
            this.subDomain = subDomain;
            this.subDomainSet = true;
        }
    }

    public class LBConfiguration
    extends Configuration
    implements Serializable {
        private static final long serialVersionUID = 1357143883932816418L;
        private String elasticIP;
        private int instances;
        private boolean isAutoscaleEnabled;
        private int autoscalerTaskInterval;
        private String autoscalerServiceEpr;
        private int serverStartupDelay;

        public LBConfiguration() {
            this.instances = 1;
            this.autoscalerTaskInterval = 5000;
            this.serverStartupDelay = 60000;
        }

        public String getElasticIP() {
            return this.elasticIP;
        }

        public int getInstances() {
            return this.instances;
        }

        public boolean isAutoscaleEnabled() {
            return this.isAutoscaleEnabled;
        }

        public String getAutoscalerServiceEpr() {
            return this.autoscalerServiceEpr;
        }

        public int getAutoscalerTaskInterval() {
            return this.autoscalerTaskInterval;
        }

        public int getServerStartupDelay() {
            return this.serverStartupDelay;
        }

        public void setElasticIP(String elasticIP) {
            this.elasticIP = LoadBalancerConfigUtil.replaceVariables(elasticIP);
        }

        public void setInstances(int instances) {
            this.instances = instances;
        }

        public void setEnable_autoscaler(String isEnabled) {
            this.isAutoscaleEnabled = Boolean.parseBoolean(isEnabled);
        }

        public void setAutoscaler_service_epr(String epr) {
            this.autoscalerServiceEpr = epr;
        }

        public void setAutoscaler_task_interval(String interval) {
            this.autoscalerTaskInterval = Integer.parseInt(interval);
        }

        public void setServer_startup_delay(String delay) {
            this.serverStartupDelay = Integer.parseInt(delay);
        }
    }

    public abstract class Configuration
    implements Serializable {
        protected String imageId = System.getenv("ami_id");
        protected String payload;
        protected boolean payloadSet;
        protected String availability_zone = "us-east-1c";
        protected boolean availabilityZoneSet;
        protected String[] security_groups = new String[]{"default"};
        protected boolean securityGroupsSet;
        protected String instance_type = "m1.large";
        protected boolean instanceTypeSet;
        protected String additional_info;

        public String getImageId() {
            return this.imageId;
        }

        public String getAdditionalInfo() {
            return this.additional_info;
        }

        public String getAvailability_zone() {
            if (this instanceof LBConfiguration) {
                return this.availability_zone;
            }
            if (this.availabilityZoneSet) {
                return this.availability_zone;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.availabilityZoneSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.availability_zone;
            }
            return this.availability_zone;
        }

        public String[] getSecurityGroups() {
            if (this instanceof LBConfiguration) {
                return this.security_groups;
            }
            if (this.securityGroupsSet) {
                return this.security_groups;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.securityGroupsSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.security_groups;
            }
            return this.security_groups;
        }

        public String getInstanceType() {
            if (this instanceof LBConfiguration) {
                return this.instance_type;
            }
            if (this.instanceTypeSet) {
                return this.instance_type;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.instanceTypeSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.instance_type;
            }
            return this.instance_type;
        }

        public String getUserData() {
            if (this.payload == null) {
                this.payload = LoadBalancerConfigUtil.getUserData("resources/cluster_node.zip");
            }
            if (this instanceof LBConfiguration) {
                return this.payload;
            }
            if (this.payloadSet) {
                return this.payload;
            }
            if (LoadBalancerConfiguration.this.defaultServiceConfig != null && LoadBalancerConfiguration.this.defaultServiceConfig.payloadSet) {
                return LoadBalancerConfiguration.this.defaultServiceConfig.payload;
            }
            return this.payload;
        }

        public void setPayload(String payload) {
            this.payload = LoadBalancerConfigUtil.getUserData(LoadBalancerConfigUtil.replaceVariables(payload));
            this.payloadSet = true;
        }

        public void setAvailability_zone(String availabilityZone) {
            this.availability_zone = LoadBalancerConfigUtil.replaceVariables(availabilityZone);
            this.availabilityZoneSet = true;
        }

        public void setSecurity_groups(String securityGroups) {
            this.security_groups = LoadBalancerConfigUtil.replaceVariables(securityGroups).split(",");
            this.securityGroupsSet = true;
        }

        public void setInstance_type(String instanceType) {
            this.instance_type = LoadBalancerConfigUtil.replaceVariables(instanceType);
            this.instanceTypeSet = true;
        }
    }
}

