/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.conf;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.synapse.commons.util.PropertyHelper;
import org.wso2.carbon.lb.common.conf.LoadBalancerConfiguration;
import org.wso2.carbon.lb.common.conf.structure.Node;
import org.wso2.carbon.lb.common.conf.structure.NodeBuilder;
import org.wso2.carbon.lb.common.conf.util.LoadBalancerConfigUtil;

public class EC2Configuration
extends LoadBalancerConfiguration {
    private String ec2_access_key = "access.key";
    private String ec2_private_key = "private.key";
    private String ec2_ssh_key = "stratos - 1.0.0-keypair";
    private String instance_mgt_epr = "https://ec2.amazonaws.com/";
    private boolean disable_api_termination;
    private boolean enable_monitoring;

    public String getEc2_access_key() {
        return this.ec2_access_key;
    }

    public void setEc2_access_key(String ec2_access_key) {
        this.ec2_access_key = LoadBalancerConfigUtil.replaceVariables(ec2_access_key);
    }

    public String getEc2_private_key() {
        return this.ec2_private_key;
    }

    public void setEc2_private_key(String ec2_private_key) {
        this.ec2_private_key = LoadBalancerConfigUtil.replaceVariables(ec2_private_key);
    }

    public String getEc2_ssh_key() {
        return this.ec2_ssh_key;
    }

    public void setEc2_ssh_key(String ec2_ssh_key) {
        this.ec2_ssh_key = ec2_ssh_key;
    }

    public String getInstance_mgt_epr() {
        return this.instance_mgt_epr;
    }

    public void setInstance_mgt_epr(String instance_mgt_epr) {
        this.instance_mgt_epr = instance_mgt_epr;
    }

    public boolean getDisable_api_termination() {
        return this.disable_api_termination;
    }

    public void setDisable_api_termination(boolean disable_api_termination) {
        this.disable_api_termination = disable_api_termination;
    }

    public boolean getEnable_monitoring() {
        return this.enable_monitoring;
    }

    public void setEnable_monitoring(boolean enable_monitoring) {
        this.enable_monitoring = enable_monitoring;
    }

    @Override
    public void init(String configURL) {
        if (configURL.startsWith("$system:")) {
            configURL = System.getProperty(configURL.substring("$system:".length()));
        }
        try {
            this.lbConfigString = configURL.startsWith(File.separator) ? this.createLBConfigString(configURL) : this.createLBConfigString(new URL(configURL).openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read configuration file from " + configURL);
        }
        this.rootNode = new Node();
        this.rootNode.setName("root");
        this.rootNode = NodeBuilder.buildNode(this.rootNode, this.lbConfigString);
        Map<String, String> rootProperties = this.rootNode.getProperties();
        for (Map.Entry<String, String> entry : rootProperties.entrySet()) {
            PropertyHelper.setInstanceProperty((String)entry.getKey(), (Object)entry.getValue(), (Object)this);
        }
        Node lbConfigNode = this.rootNode.findChildNodeByName("loadbalancer");
        if (lbConfigNode == null) {
            throw new RuntimeException("Mandatory loadbalancer element can not be found in configuration file.");
        }
        this.lbConfig = new LoadBalancerConfiguration.LBConfiguration(this);
        this.createConfiguration(this.lbConfig, lbConfigNode);
        Node servicesConfigNode = this.rootNode.findChildNodeByName("services");
        if (servicesConfigNode == null) {
            throw new RuntimeException("Mandatory services element can not be found in configuration file.");
        }
        this.createServicesConfig(servicesConfigNode);
    }

    @Override
    public void createServicesConfig(Node servicesConfigNode) {
        Node defaultNode = servicesConfigNode.findChildNodeByName("defaults");
        this.defaultServiceConfig = new LoadBalancerConfiguration.ServiceConfiguration(this, null);
        this.createConfiguration(this.defaultServiceConfig, defaultNode);
        for (Node serviceNode : servicesConfigNode.getChildNodes()) {
            Node domainsNode;
            if (serviceNode == defaultNode) continue;
            String serviceName = serviceNode.getName();
            if (serviceNode.getChildNodes().isEmpty() || !(domainsNode = serviceNode.getChildNodes().get(0)).getName().equals("domains")) {
                throw new RuntimeException("The mandatory domains element child of the " + serviceName + " element is not specified");
            }
            if (domainsNode.getChildNodes().isEmpty()) {
                throw new RuntimeException("No domain is specified under domains of " + serviceName + " element.");
            }
            for (Node domain : domainsNode.getChildNodes()) {
                LoadBalancerConfiguration.ServiceConfiguration serviceConfig = new LoadBalancerConfiguration.ServiceConfiguration(this, domain.getName());
                this.createConfiguration(serviceConfig, domain, serviceNode);
                this.serviceConfigMap.put(domain.getName(), serviceConfig);
            }
        }
    }

    protected void createConfiguration(LoadBalancerConfiguration.Configuration config, Node node, Node parentNode) {
        String value;
        String key;
        if (node == null) {
            throw new RuntimeException("The configuration element for " + config.getClass().getName() + " is null");
        }
        try {
            for (Map.Entry<String, String> entry : parentNode.getProperties().entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                PropertyHelper.setInstanceProperty((String)key, (Object)value, (Object)config);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting values to " + config.getClass().getName(), e);
        }
        try {
            for (Map.Entry<String, String> entry : node.getProperties().entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                PropertyHelper.setInstanceProperty((String)key, (Object)value, (Object)config);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting values to " + config.getClass().getName(), e);
        }
    }
}

