/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LBConfigParser {
    private static Log log = LogFactory.getLog(LBConfigParser.class);

    public String createLBConfigString(String configFileName) throws FileNotFoundException {
        StringBuilder lbConfigString = new StringBuilder("");
        File configFile = new File(configFileName);
        Scanner scanner = new Scanner(configFile);
        while (scanner.hasNextLine()) {
            lbConfigString.append(scanner.nextLine().trim() + "\n");
        }
        return lbConfigString.toString().trim();
    }

    public String createLBConfigString(InputStream configFileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(configFileName));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line.trim() + "\n");
        }
        return sb.toString().trim();
    }

    public String dragConfigTagFromFile(String configFileName, String elementName) {
        File configFile = new File(configFileName);
        Scanner scanner = null;
        try {
            scanner = new Scanner(configFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Stack<String> stack = new Stack<String>();
        String servicesContentSubString = "";
        boolean insideServicesTag = false;
        if (scanner == null) {
            log.warn((Object)"Can not read load balance configuration file. Load balance configuration will not be available !!!");
            return null;
        }
        while (scanner.hasNextLine()) {
            String lineContent = scanner.nextLine();
            if (insideServicesTag) {
                if (stack.empty()) break;
                if (stack.size() != 1 || !lineContent.contains("}")) {
                    servicesContentSubString = servicesContentSubString + lineContent;
                }
                if (lineContent.contains("{")) {
                    stack.push("{");
                }
                if (!lineContent.contains("}")) continue;
                stack.pop();
                continue;
            }
            if (!lineContent.trim().contains(elementName)) continue;
            insideServicesTag = true;
            if (!lineContent.contains("{")) continue;
            stack.push("{");
        }
        return servicesContentSubString;
    }

    public static HashMap<String, String> separateServices(String servicesContentSubString) {
        HashMap<String, String> serviceMap = new HashMap<String, String>();
        Stack<Character> stack = new Stack<Character>();
        ArrayList<Integer> startContentIndex = new ArrayList<Integer>();
        ArrayList<Integer> endContentString = new ArrayList<Integer>();
        ArrayList<String> serviceNamesList = new ArrayList<String>();
        for (int i = 0; i < servicesContentSubString.length(); ++i) {
            char ch = servicesContentSubString.charAt(i);
            if (ch == '{') {
                if (stack.empty()) {
                    String stringWithServiceName = servicesContentSubString.substring(0, i).trim();
                    String[] arrayWithServiceName = stringWithServiceName.split(" ");
                    String serviceName = arrayWithServiceName[arrayWithServiceName.length - 1];
                    serviceNamesList.add(serviceName);
                    startContentIndex.add(i);
                }
                stack.push(Character.valueOf(ch));
                continue;
            }
            if (ch != '}') continue;
            stack.pop();
            if (!stack.empty()) continue;
            endContentString.add(i);
        }
        Iterator iterator1 = startContentIndex.iterator();
        Iterator iterator2 = endContentString.iterator();
        Iterator iterator3 = serviceNamesList.iterator();
        while (iterator1.hasNext() && iterator2.hasNext() && iterator3.hasNext()) {
            int startIndex = (Integer)iterator1.next();
            int endIndex = (Integer)iterator2.next();
            String valueServiceContent = servicesContentSubString.substring(startIndex + 1, endIndex);
            String keyServiceName = (String)iterator3.next();
            serviceMap.put(keyServiceName, valueServiceContent);
        }
        return serviceMap;
    }

    public String getConfigElementFromString(String configContent, String elementName) {
        String returnElementValue = null;
        int endElementCounter = 0;
        Stack<Character> stack = new Stack<Character>();
        String[] neededConfigContent = configContent.split(elementName, 2);
        if (neededConfigContent != null && neededConfigContent.length > 1) {
            String configSubString = neededConfigContent[1].trim();
            for (int i = 0; i < configSubString.length(); ++i) {
                char ch = configSubString.charAt(i);
                if (ch == '{') {
                    stack.push(Character.valueOf(ch));
                    continue;
                }
                if (ch != '}') continue;
                stack.pop();
                if (!stack.empty()) continue;
                endElementCounter = i;
                break;
            }
            returnElementValue = configSubString.trim().substring(1, endElementCounter).trim();
        }
        return returnElementValue;
    }

    public ArrayList<String> getConfigPropertyFromString(String configContent, String propertyName) {
        int startElementCounter = 0;
        ArrayList<String> propertyValueList = new ArrayList<String>();
        String[] neededConfigContent = configContent.split(propertyName, 2);
        if (neededConfigContent != null && neededConfigContent.length > 1) {
            String configSubString = neededConfigContent[1].trim();
            for (int i = 0; i < configSubString.length(); ++i) {
                String propertyValue;
                char ch = configSubString.charAt(i);
                if (ch == ',') {
                    propertyValue = configSubString.substring(startElementCounter, i).trim();
                    propertyValueList.add(propertyValue);
                    startElementCounter = i + 1;
                }
                if (ch != ';') continue;
                propertyValue = configSubString.substring(startElementCounter, i).trim();
                propertyValueList.add(propertyValue);
                break;
            }
        }
        return propertyValueList;
    }

    public HashMap<String, String> getAllTopLevelConfigElements(String configContent) {
        Stack<Character> stack = new Stack<Character>();
        int startIndex = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: for (int i = 0; i < configContent.length(); ++i) {
            char ch = configContent.charAt(i);
            if (ch != '{') continue;
            stack.push(Character.valueOf('{'));
            String firstHalf = configContent.substring(startIndex, i).trim();
            String secondHalf = configContent.substring(i + 1, configContent.length());
            String[] firstHalfArray = firstHalf.split(" ");
            String elementName = firstHalfArray[firstHalfArray.length - 1];
            for (int j = 0; j < secondHalf.length(); ++j) {
                char ch2 = secondHalf.charAt(j);
                if (ch2 == '{') {
                    stack.push(Character.valueOf('{'));
                    continue;
                }
                if (ch2 != '}') continue;
                stack.pop();
                if (!stack.empty()) continue;
                String elementValue = secondHalf.substring(0, j);
                hashMap.put(elementName, elementValue);
                startIndex = i + j;
                i += j;
                continue block0;
            }
        }
        return hashMap;
    }
}

