/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedAttributes;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedStatus;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ServerWithSecurityGroups
extends Server {
    @Named(value="security_groups")
    private final Set<String> securityGroupNames;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerWithSecurityGroups(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "uuid", "tenant_id", "user_id", "updated", "created", "hostId", "accessIPv4", "accessIPv6", "status", "image", "flavor", "key_name", "config_drive", "addresses", "metadata", "extendedStatus", "extendedAttributes", "OS-DCF:diskConfig", "security_groups"})
    protected ServerWithSecurityGroups(String id, @Nullable String name, Set<Link> links, @Nullable String uuid, String tenantId, String userId, Date updated, Date created, @Nullable String hostId, @Nullable String accessIPv4, @Nullable String accessIPv6, Server.Status status, Resource image, Resource flavor, @Nullable String keyName, @Nullable String configDrive, Multimap<String, Address> addresses, Map<String, String> metadata, @Nullable ServerExtendedStatus extendedStatus, @Nullable ServerExtendedAttributes extendedAttributes, @Nullable String diskConfig, Set<String> securityGroupNames) {
        super(id, name, links, uuid, tenantId, userId, updated, created, hostId, accessIPv4, accessIPv6, status, image, flavor, keyName, configDrive, addresses, metadata, extendedStatus, extendedAttributes, diskConfig);
        this.securityGroupNames = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")));
    }

    public Set<String> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.securityGroupNames});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServerWithSecurityGroups that = (ServerWithSecurityGroups)((Object)ServerWithSecurityGroups.class.cast(obj));
        return super.equals((Object)that) && Objects.equal(this.securityGroupNames, that.securityGroupNames);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("securityGroupNames", this.securityGroupNames);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Server.Builder<T> {
        protected Set<String> securityGroupNames = ImmutableSet.of();

        public T securityGroupNames(Set<String> securityGroupNames) {
            this.securityGroupNames = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")));
            return (T)((Object)((Builder)this.self()));
        }

        public T securityGroupNames(String ... in) {
            return this.securityGroupNames((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        @Override
        public ServerWithSecurityGroups build() {
            return new ServerWithSecurityGroups(this.id, this.name, this.links, this.uuid, this.tenantId, this.userId, this.updated, this.created, this.hostId, this.accessIPv4, this.accessIPv6, this.status, this.image, this.flavor, this.keyName, this.configDrive, (Multimap<String, Address>)this.addresses, this.metadata, this.extendedStatus, this.extendedAttributes, this.diskConfig, this.securityGroupNames);
        }

        public T fromServerWithSecurityGroups(ServerWithSecurityGroups in) {
            return ((Builder)((Object)super.fromServer(in))).securityGroupNames(in.getSecurityGroupNames());
        }
    }
}

