/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.NovaClient;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairClient;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupClient;
import org.jclouds.openstack.nova.v2_0.predicates.KeyPairPredicates;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

@Singleton
public class NovaComputeService
extends BaseComputeService {
    protected final NovaClient novaClient;
    protected final LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupMap;
    protected final LoadingCache<ZoneAndName, KeyPair> keyPairCache;
    protected final Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByZoneId;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    protected NovaComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, NovaClient novaClient, LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupMap, LoadingCache<ZoneAndName, KeyPair> keyPairCache, Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByZoneId, GroupNamingConvention.Factory namingConvention, Optional<ImageExtension> imageExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, executor, imageExtension);
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
        this.securityGroupMap = (LoadingCache)Preconditions.checkNotNull(securityGroupMap, (Object)"securityGroupMap");
        this.keyPairCache = (LoadingCache)Preconditions.checkNotNull(keyPairCache, (Object)"keyPairCache");
        this.orphanedGroupsByZoneId = (Function)Preconditions.checkNotNull(orphanedGroupsByZoneId, (Object)"orphanedGroupsByZoneId");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
    }

    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Multimap zoneToZoneAndGroupNames = (Multimap)this.orphanedGroupsByZoneId.apply(deadNodes);
        for (String zoneId : zoneToZoneAndGroupNames.keySet()) {
            this.cleanOrphanedGroupsInZone((Set<String>)ImmutableSet.copyOf((Collection)zoneToZoneAndGroupNames.get((Object)zoneId)), zoneId);
        }
    }

    protected void cleanOrphanedGroupsInZone(Set<String> groups, String zoneId) {
        this.cleanupOrphanedSecurityGroupsInZone(groups, zoneId);
        this.cleanupOrphanedKeyPairsInZone(groups, zoneId);
    }

    private void cleanupOrphanedSecurityGroupsInZone(Set<String> groups, String zoneId) {
        Optional<SecurityGroupClient> securityGroupClient = this.novaClient.getSecurityGroupExtensionForZone(zoneId);
        if (securityGroupClient.isPresent()) {
            for (String group : groups) {
                for (SecurityGroup securityGroup : Iterables.filter(((SecurityGroupClient)securityGroupClient.get()).listSecurityGroups(), SecurityGroupPredicates.nameMatches((Predicate<String>)this.namingConvention.create().containsGroup(group)))) {
                    ZoneAndName zoneAndName = ZoneAndName.fromZoneAndName(zoneId, securityGroup.getName());
                    this.logger.debug(">> deleting securityGroup(%s)", new Object[]{zoneAndName});
                    ((SecurityGroupClient)securityGroupClient.get()).deleteSecurityGroup(securityGroup.getId());
                    this.securityGroupMap.invalidate((Object)zoneAndName);
                    this.logger.debug("<< deleted securityGroup(%s)", new Object[]{zoneAndName});
                }
            }
        }
    }

    private void cleanupOrphanedKeyPairsInZone(Set<String> groups, String zoneId) {
        Optional<KeyPairClient> keyPairClient = this.novaClient.getKeyPairExtensionForZone(zoneId);
        if (keyPairClient.isPresent()) {
            for (String group : groups) {
                for (Map<String, KeyPair> view : ((KeyPairClient)keyPairClient.get()).listKeyPairs()) {
                    for (KeyPair pair : Iterables.filter(view.values(), KeyPairPredicates.nameMatches((Predicate<String>)this.namingConvention.create().containsGroup(group)))) {
                        ZoneAndName zoneAndName = ZoneAndName.fromZoneAndName(zoneId, pair.getName());
                        this.logger.debug(">> deleting keypair(%s)", new Object[]{zoneAndName});
                        ((KeyPairClient)keyPairClient.get()).deleteKeyPair(pair.getName());
                        this.keyPairCache.invalidate((Object)zoneAndName);
                        this.logger.debug("<< deleted keypair(%s)", new Object[]{zoneAndName});
                    }
                }
                this.keyPairCache.invalidate((Object)ZoneAndName.fromZoneAndName(zoneId, this.namingConvention.create().sharedNameForGroup(group)));
            }
        }
    }

    public NovaTemplateOptions templateOptions() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.templateOptions());
    }
}

