/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;

@Singleton
public class EncodedRSAPublicKeyToBase64
implements Function<Object, String> {
    private static final Predicate<Object> ALLOWED_MARKERS = Predicates.or((Predicate[])new Predicate[]{EncodedRSAPublicKeyToBase64.startsWith("ssh-rsa"), EncodedRSAPublicKeyToBase64.startsWith("-----BEGIN CERTIFICATE-----"), EncodedRSAPublicKeyToBase64.startsWith("---- BEGIN SSH2 PUBLIC KEY ----")});

    private static Predicate<Object> startsWith(String value) {
        return new ToStringStartsWith(value);
    }

    public String apply(Object from) {
        Preconditions.checkNotNull((Object)from, (Object)"input");
        Preconditions.checkArgument((boolean)ALLOWED_MARKERS.apply(from), (String)"must be a ssh public key, conforming to %s ", (Object[])new Object[]{ALLOWED_MARKERS});
        return CryptoStreams.base64((byte[])from.toString().getBytes(Charsets.UTF_8));
    }

    private static final class ToStringStartsWith
    implements Predicate<Object> {
        private final String value;

        private ToStringStartsWith(String value) {
            this.value = value;
        }

        public boolean apply(Object input) {
            return input.toString().startsWith(this.value);
        }

        public String toString() {
            return "toStringStartsWith(" + this.value + ")";
        }
    }
}

