/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Preconditions;
import java.util.Date;

public class Spot
implements Comparable<Spot> {
    private final String region;
    private final String instanceType;
    private final String productDescription;
    private final float spotPrice;
    private final Date timestamp;

    public static Builder builder() {
        return new Builder();
    }

    public Spot(String region, String instanceType, String productDescription, float spotPrice, Date timestamp) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.instanceType = (String)Preconditions.checkNotNull((Object)instanceType, (Object)"instanceType");
        this.productDescription = (String)Preconditions.checkNotNull((Object)productDescription, (Object)"productDescription");
        this.spotPrice = spotPrice;
        this.timestamp = (Date)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
    }

    public String getRegion() {
        return this.region;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public float getSpotPrice() {
        return this.spotPrice;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(Spot o) {
        return Float.compare(this.spotPrice, o.spotPrice);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceType == null ? 0 : this.instanceType.hashCode());
        result = 31 * result + (this.productDescription == null ? 0 : this.productDescription.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + Float.floatToIntBits(this.spotPrice);
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Spot other = (Spot)obj;
        if (this.instanceType == null ? other.instanceType != null : !this.instanceType.equals(other.instanceType)) {
            return false;
        }
        if (this.productDescription == null ? other.productDescription != null : !this.productDescription.equals(other.productDescription)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (Float.floatToIntBits(this.spotPrice) != Float.floatToIntBits(other.spotPrice)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public String toString() {
        return "[region=" + this.region + ", instanceType=" + this.instanceType + ", productDescription=" + this.productDescription + ", spotPrice=" + this.spotPrice + ", timestamp=" + this.timestamp + "]";
    }

    public static class Builder {
        private String region;
        private String instanceType;
        private String productDescription;
        private float spotPrice;
        private Date timestamp;

        public void clear() {
            this.region = null;
            this.instanceType = null;
            this.productDescription = null;
            this.spotPrice = 0.0f;
            this.timestamp = null;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public Builder spotPrice(float spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Spot build() {
            return new Spot(this.region, this.instanceType, this.productDescription, this.spotPrice, this.timestamp);
        }
    }
}

