/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.functions.EndpointToSupplierURI;

@Singleton
public class LocationIdToURIFromAccessForTypeAndVersion
implements Supplier<Map<String, Supplier<URI>>> {
    protected final Supplier<Access> access;
    protected final EndpointToSupplierURI endpointToSupplierURI;
    protected final Function<Endpoint, String> endpointToLocationId;
    protected final String apiType;
    protected final String apiVersion;

    @Inject
    public LocationIdToURIFromAccessForTypeAndVersion(Supplier<Access> access, EndpointToSupplierURI endpointToSupplierURI, Function<Endpoint, String> endpointToLocationId, @Assisted(value="apiType") String apiType, @Assisted(value="apiVersion") String apiVersion) {
        this.access = access;
        this.endpointToSupplierURI = endpointToSupplierURI;
        this.endpointToLocationId = endpointToLocationId;
        this.apiType = apiType;
        this.apiVersion = apiVersion;
    }

    public Map<String, Supplier<URI>> get() {
        Access accessResponse = (Access)this.access.get();
        Set services = Sets.filter(accessResponse.getServiceCatalog(), (Predicate)new Predicate<Service>(){

            public boolean apply(Service input) {
                return input.getType().equals(LocationIdToURIFromAccessForTypeAndVersion.this.apiType);
            }
        });
        if (services.size() == 0) {
            throw new NoSuchElementException(String.format("apiType %s not found in catalog %s", this.apiType, accessResponse.getServiceCatalog()));
        }
        Iterable endpoints = Iterables.filter((Iterable)Iterables.concat((Iterable)services), (Predicate)new Predicate<Endpoint>(){

            public boolean apply(Endpoint input) {
                if (input.getVersionId() == null) {
                    return true;
                }
                return input.getVersionId().equals(LocationIdToURIFromAccessForTypeAndVersion.this.apiVersion);
            }
        });
        if (Iterables.size((Iterable)endpoints) == 0) {
            throw new NoSuchElementException(String.format("no endpoints for apiType %s are of version %s, or version agnostic: %s", this.apiType, this.apiVersion, services));
        }
        ImmutableMap locationIdToEndpoint = Maps.uniqueIndex((Iterable)endpoints, this.endpointToLocationId);
        return Maps.transformValues((Map)locationIdToEndpoint, (Function)this.endpointToSupplierURI);
    }

    public String toString() {
        return "locationIdToURIFromAccessForTypeAndVersion(" + this.apiType + ", " + this.apiVersion + ")";
    }
}

