/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Role;

public class User {
    private final String id;
    private final String name;
    private final Set<Role> roles;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUser(this);
    }

    @ConstructorProperties(value={"id", "name", "roles"})
    protected User(String id, String name, @Nullable Set<Role> roles) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.roles = roles == null ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(roles, (Object)"roles")));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.roles});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User that = (User)User.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.roles, that.roles);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("roles", this.roles);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected Set<Role> roles = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T roles(Set<Role> roles) {
            this.roles = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(roles, (Object)"roles")));
            return this.self();
        }

        public T roles(Role ... in) {
            return this.roles((Set<Role>)ImmutableSet.copyOf((Object[])in));
        }

        public User build() {
            return new User(this.id, this.name, this.roles);
        }

        public T fromUser(User in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).roles(in.getRoles());
        }
    }
}

