/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.handlers;

import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class NovaErrorHandler
implements HttpErrorHandler {
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String message = data != null ? new String(data) : null;
        Object exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 400: {
                if (message.indexOf("quota exceeded") != -1) {
                    exception = new InsufficientResourcesException(message, (Throwable)exception);
                    break;
                }
                if (message.indexOf("has no fixed_ips") != -1) {
                    exception = new IllegalStateException(message, (Throwable)exception);
                    break;
                }
                if (message.indexOf("already exists") == -1) break;
                exception = new IllegalStateException(message, (Throwable)exception);
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, (Throwable)exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, (Throwable)exception);
                break;
            }
            case 413: {
                exception = new InsufficientResourcesException(message, (Throwable)exception);
            }
        }
        command.setException((Exception)exception);
    }
}

