/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.openstack.nova.v2_0.predicates.ExtensionPredicates;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@Singleton
public class PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet
implements ImplicitOptionalConverter {
    private final LoadingCache<String, Set<org.jclouds.openstack.nova.v2_0.domain.Extension>> extensions;
    @Inject(optional=true)
    @Named(value="openstack.nova.extensions")
    Multimap<URI, URI> aliases = ImmutableMultimap.builder().put((Object)URI.create("http://docs.openstack.org/ext/securitygroups/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/securitygroups/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/floating_ips/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/floating_ips/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/keypairs/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/os-simple-tenant-usage/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/os-simple-tenant-usage/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/hosts/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/hosts/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/volumes/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/volumes/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/virtual_interfaces/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/virtual_interfaces/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/createserverext/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/createserverext/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/admin-actions/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/admin-actions/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/aggregates/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/aggregates/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/flavor_extra_specs/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/flavor_extra_specs/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/quotas-sets/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/quotas-sets/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/quota-classes-sets/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/quota-classes-sets/api/v1.1")).put((Object)URI.create("http://docs.openstack.org/ext/volume_types/api/v1.1"), (Object)URI.create("http://docs.openstack.org/compute/ext/volume_types/api/v1.1")).build();

    @javax.inject.Inject
    public PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet(LoadingCache<String, Set<org.jclouds.openstack.nova.v2_0.domain.Extension>> extensions) {
        this.extensions = (LoadingCache)Preconditions.checkNotNull(extensions, (Object)"extensions");
    }

    public Optional<Object> apply(ClassMethodArgsAndReturnVal input) {
        Optional ext = Optional.fromNullable((Object)input.getClazz().getAnnotation(Extension.class));
        if (ext.isPresent()) {
            Preconditions.checkState((input.getArgs() != null && input.getArgs().length == 1 ? 1 : 0) != 0, (String)"expecting an arg %s", (Object[])new Object[]{input});
            URI namespace = URI.create(((Extension)ext.get()).namespace());
            if (Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)Preconditions.checkNotNull((Object)input.getArgs()[0], (String)"arg[0] in %s", (Object[])new Object[]{input}).toString())), ExtensionPredicates.namespaceOrAliasEquals(namespace, this.aliases.get((Object)namespace)))) {
                return Optional.of((Object)input.getReturnVal());
            }
        }
        return Optional.absent();
    }

    public String toString() {
        return "presentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet()";
    }
}

