/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class IgnoreNullMultimapTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (typeToken.getRawType() != Multimap.class || !(type instanceof ParameterizedType)) {
            return null;
        }
        Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
        Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
        TypeAdapter keyAdapter = gson.getAdapter(TypeToken.get((Type)keyType));
        TypeAdapter valueAdapter = gson.getAdapter(TypeToken.get((Type)valueType));
        return this.newMapAdapter(keyAdapter, valueAdapter);
    }

    private <K, V> TypeAdapter<Multimap<K, V>> newMapAdapter(final TypeAdapter<K> keyAdapter, final TypeAdapter<V> valueAdapter) {
        return new TypeAdapter<Multimap<K, V>>(){

            public void write(JsonWriter out, Multimap<K, V> map) throws IOException {
                out.beginObject();
                for (Object key : map.keySet()) {
                    out.name(String.valueOf(key));
                    out.beginArray();
                    for (Object value : map.get(key)) {
                        valueAdapter.write(out, value);
                    }
                    out.endArray();
                }
                out.endObject();
            }

            public Multimap<K, V> read(JsonReader in) throws IOException {
                ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
                in.beginObject();
                while (in.hasNext()) {
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                    Object name = keyAdapter.read(in);
                    in.beginArray();
                    while (in.hasNext()) {
                        Object value = valueAdapter.read(in);
                        if (value == null) continue;
                        result.put(name, value);
                    }
                    in.endArray();
                }
                in.endObject();
                return result.build();
            }
        }.nullSafe();
    }
}

