/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Strings2;

public class ModifyRequest {
    public static <R extends HttpRequest> R putHeaders(R request, Multimap<String, String> moreHeaders) {
        return (R)((HttpRequest.Builder)request.toBuilder().headers((Multimap)ImmutableMultimap.builder().putAll(request.getHeaders()).putAll(moreHeaders).build())).build();
    }

    public static <R extends HttpRequest> R endpoint(R request, URI endpoint) {
        return (R)((HttpRequest)Preconditions.checkNotNull(request, (Object)"request")).toBuilder().endpoint((URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint")).build();
    }

    public static <R extends HttpRequest> R replaceHeaders(R request, Multimap<String, String> headers) {
        LinkedHashMultimap newHeaders = LinkedHashMultimap.create(((HttpRequest)Preconditions.checkNotNull(request, (Object)"request")).getHeaders());
        for (String header : headers.keySet()) {
            newHeaders.replaceValues((Object)header, (Iterable)headers.get((Object)header));
        }
        return (R)((HttpRequest.Builder)request.toBuilder().headers((Multimap)newHeaders)).build();
    }

    public static <R extends HttpRequest> R replaceHeader(R request, String header, String ... values) {
        return ModifyRequest.replaceHeader(request, header, (Iterable<String>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)values, (Object)"values"))));
    }

    public static <R extends HttpRequest> R replaceHeader(R request, String header, Iterable<String> values) {
        LinkedHashMultimap headers = LinkedHashMultimap.create(((HttpRequest)Preconditions.checkNotNull(request, (Object)"request")).getHeaders());
        headers.replaceValues(Preconditions.checkNotNull((Object)header, (Object)"header"), (Iterable)Preconditions.checkNotNull(values, (Object)"values"));
        return (R)((HttpRequest.Builder)request.toBuilder().headers((Multimap)headers)).build();
    }

    public static <R extends HttpRequest> R removeHeader(R request, String header) {
        LinkedHashMultimap headers = LinkedHashMultimap.create(((HttpRequest)Preconditions.checkNotNull(request, (Object)"request")).getHeaders());
        headers.removeAll(Preconditions.checkNotNull((Object)header, (Object)"header"));
        return (R)((HttpRequest.Builder)request.toBuilder().headers((Multimap)headers)).build();
    }

    public static <R extends HttpRequest> R addQueryParam(R request, String key, Object value, UriBuilder builder) {
        return ModifyRequest.addQueryParam(request, key, ImmutableSet.of((Object)value), builder, request.getSkips());
    }

    public static <R extends HttpRequest> R addQueryParam(R request, String key, Iterable<?> values, UriBuilder builder) {
        return ModifyRequest.addQueryParam(request, key, values, builder, request.getSkips());
    }

    public static <R extends HttpRequest> R addQueryParam(R request, String key, Iterable<?> values, UriBuilder builder, char ... skips) {
        builder.uri(request.getEndpoint());
        Multimap<String, String> map = ModifyRequest.parseQueryToMap(request.getEndpoint().getQuery());
        for (Object o : values) {
            map.put((Object)key, (Object)o.toString());
        }
        builder.replaceQuery(ModifyRequest.makeQueryLine(map, null, skips));
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }

    public static <R extends HttpRequest> R addQueryParams(R request, Multimap<String, String> parameters, UriBuilder builder) {
        return ModifyRequest.addQueryParams(request, parameters, builder, request.getSkips());
    }

    public static <R extends HttpRequest> R addQueryParams(R request, Multimap<String, String> parameters, UriBuilder builder, char ... skips) {
        builder.uri(request.getEndpoint());
        Multimap<String, String> map = ModifyRequest.parseQueryToMap(request.getEndpoint().getQuery());
        map.putAll(parameters);
        builder.replaceQuery(ModifyRequest.makeQueryLine(map, null, skips));
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }

    public static <R extends HttpRequest> R replaceMatrixParam(R request, String name, Object value, UriBuilder builder) {
        return ModifyRequest.replaceMatrixParam(request, name, new Object[]{value}, builder);
    }

    public static <R extends HttpRequest> R replaceMatrixParam(R request, String name, Object[] values, UriBuilder builder) {
        builder.uri(request.getEndpoint());
        builder.replaceMatrixParam(name, values);
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }

    public static <R extends HttpRequest> R addFormParam(R request, String key, String value) {
        return ModifyRequest.addFormParam(request, key, ImmutableSet.of((Object)value));
    }

    public static <R extends HttpRequest> R addFormParam(R request, String key, Iterable<?> values) {
        Multimap<String, String> map = request.getPayload() != null ? ModifyRequest.parseQueryToMap(request.getPayload().getRawContent().toString()) : LinkedHashMultimap.create();
        for (Object o : values) {
            map.put((Object)key, (Object)o.toString());
        }
        return (R)request.toBuilder().payload(Payloads.newUrlEncodedFormPayload(map, new char[0])).build();
    }

    public static <R extends HttpRequest> R putFormParams(R request, Multimap<String, String> params) {
        Multimap<String, String> map = request.getPayload() != null ? ModifyRequest.parseQueryToMap(request.getPayload().getRawContent().toString()) : LinkedHashMultimap.create();
        map.putAll(params);
        return (R)request.toBuilder().payload(Payloads.newUrlEncodedFormPayload(map, new char[0])).build();
    }

    public static Multimap<String, String> parseQueryToMap(String in) {
        LinkedListMultimap map = LinkedListMultimap.create();
        if (in != null) {
            if (in.indexOf(38) == -1) {
                if (in.contains("=")) {
                    ModifyRequest.parseKeyValueFromStringToMap(in, (Multimap<String, String>)map);
                } else {
                    map.put((Object)in, null);
                }
            } else {
                String[] parts;
                for (String part : parts = in.split("&")) {
                    ModifyRequest.parseKeyValueFromStringToMap(part, (Multimap<String, String>)map);
                }
            }
        }
        return map;
    }

    public static void parseKeyValueFromStringToMap(String stringToParse, Multimap<String, String> map) {
        int indexOfFirstEquals = stringToParse.indexOf(61);
        String key = indexOfFirstEquals == -1 ? stringToParse : stringToParse.substring(0, indexOfFirstEquals);
        String value = indexOfFirstEquals == -1 ? null : stringToParse.substring(indexOfFirstEquals + 1);
        map.put((Object)Strings2.urlDecode(key), (Object)Strings2.urlDecode(value));
    }

    public static String makeQueryLine(Multimap<String, String> params, @Nullable Comparator<Map.Entry<String, String>> sorter, char ... skips) {
        Iterator pairs = (sorter == null ? params.entries() : ImmutableSortedSet.copyOf(sorter, (Collection)params.entries())).iterator();
        StringBuilder formBuilder = new StringBuilder();
        while (pairs.hasNext()) {
            Map.Entry pair = (Map.Entry)pairs.next();
            formBuilder.append(Strings2.urlEncode((String)pair.getKey(), skips));
            if (pair.getValue() != null) {
                formBuilder.append("=");
            }
            if (pair.getValue() != null && !((String)pair.getValue()).equals("")) {
                formBuilder.append(Strings2.urlEncode((String)pair.getValue(), skips));
            }
            if (!pairs.hasNext()) continue;
            formBuilder.append("&");
        }
        return formBuilder.toString();
    }
}

