/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.config;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jclouds.logging.Logger;

public class SSLModule
extends AbstractModule {
    protected void configure() {
        this.bind(HostnameVerifier.class).annotatedWith((Annotation)Names.named((String)"untrusted")).to(LogToMapHostnameVerifier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<SSLContext>>(){}).annotatedWith((Annotation)Names.named((String)"untrusted")).to((TypeLiteral)new TypeLiteral<UntrustedSSLContextSupplier>(){});
    }

    @Singleton
    static class TrustAllCerts
    implements X509TrustManager {
        TrustAllCerts() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    @Singleton
    public static class UntrustedSSLContextSupplier
    implements Supplier<SSLContext> {
        private final TrustAllCerts trustAllCerts;

        @Inject
        UntrustedSSLContextSupplier(TrustAllCerts trustAllCerts) {
            this.trustAllCerts = trustAllCerts;
        }

        public SSLContext get() {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{this.trustAllCerts}, new SecureRandom());
                return sc;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Singleton
    static class LogToMapHostnameVerifier
    implements HostnameVerifier {
        @Resource
        private Logger logger = Logger.NULL;
        private final Map<String, String> sslMap = Maps.newHashMap();

        LogToMapHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            this.logger.warn("hostname was %s while session was %s", hostname, session.getPeerHost());
            this.sslMap.put(hostname, session.getPeerHost());
            return true;
        }
    }
}

