/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.http.HttpMessage;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public class HttpResponse
extends HttpMessage {
    private final int statusCode;
    private final String message;

    public static Builder builder() {
        return new Builder();
    }

    public HttpResponse(int statusCode, String message, @Nullable Payload payload) {
        this(statusCode, message, payload, (Multimap<String, String>)ImmutableMultimap.of());
    }

    public HttpResponse(int statusCode, String message, @Nullable Payload payload, Multimap<String, String> headers) {
        super(payload, headers);
        this.statusCode = statusCode;
        this.message = message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return "[message=" + this.message + ", statusCode=" + this.statusCode + ", headers=" + this.headers + ", payload=" + this.payload + "]";
    }

    public String getStatusLine() {
        return String.format("HTTP/1.1 %d %s", this.getStatusCode(), this.getMessage());
    }

    @Override
    public Builder toBuilder() {
        return Builder.from(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.statusCode;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpResponse other = (HttpResponse)obj;
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.statusCode == other.statusCode;
    }

    public static class Builder
    extends HttpMessage.Builder {
        private int statusCode;
        private String message;

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public Builder payload(Payload payload) {
            return (Builder)super.payload(payload);
        }

        @Override
        public Builder headers(Multimap<String, String> headers) {
            return (Builder)super.headers(headers);
        }

        @Override
        public HttpResponse build() {
            return new HttpResponse(this.statusCode, this.message, this.payload, (Multimap<String, String>)this.headers);
        }

        public static Builder from(HttpResponse input) {
            return new Builder().message(input.getMessage()).statusCode(input.getStatusCode()).payload(input.getPayload()).headers((Multimap)input.getHeaders());
        }
    }
}

