/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Date;
import javax.inject.Singleton;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.date.DateService;

@Singleton
public class DateServiceDateCodecFactory
implements DateCodecFactory {
    private final DateCodec rfc1123Codec;

    @Inject
    public DateServiceDateCodecFactory(DateServiceRfc1123Codec rfc1123Codec) {
        this.rfc1123Codec = (DateCodec)Preconditions.checkNotNull((Object)rfc1123Codec, (Object)"rfc1123Codec");
    }

    @Override
    public DateCodec rfc1123() {
        return this.rfc1123Codec;
    }

    @Singleton
    public static class DateServiceRfc1123Codec
    implements DateCodec {
        private final DateService dateService;

        @Inject
        public DateServiceRfc1123Codec(DateService dateService) {
            this.dateService = (DateService)Preconditions.checkNotNull((Object)dateService, (Object)"dateService");
        }

        @Override
        public Date toDate(String date) throws IllegalArgumentException {
            return this.dateService.rfc1123DateParse(date);
        }

        @Override
        public String toString(Date date) {
            return this.dateService.rfc1123DateFormat(date);
        }

        public String toString() {
            return "rfc1123Codec [dateService=" + this.dateService + "]";
        }
    }
}

