/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.ProvisionException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.concurrent.Timeout;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.util.Optionals2;
import org.jclouds.util.Throwables2;

public class SyncProxy
implements InvocationHandler {
    private final Function<ClassMethodArgsAndReturnVal, Optional<Object>> optionalConverter;
    private final Object delegate;
    private final Class<?> declaring;
    private final Map<Method, Method> methodMap;
    private final Map<Method, Method> syncMethodMap;
    private final Map<Method, Long> timeoutMap;
    private final LoadingCache<ClassMethodArgs, Object> delegateMap;
    private final Map<Class<?>, Class<?>> sync2Async;
    private static final Set<Method> objectMethods = ImmutableSet.copyOf((Object[])Object.class.getMethods());

    public static <T> T proxy(Function<ClassMethodArgsAndReturnVal, Optional<Object>> optionalConverter, Class<T> clazz, Object async, @Named(value="sync") LoadingCache<ClassMethodArgs, Object> delegateMap, Map<Class<?>, Class<?>> sync2Async, Map<String, Long> timeouts) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new SyncProxy(optionalConverter, clazz, async, delegateMap, sync2Async, timeouts));
    }

    @Inject
    private SyncProxy(Function<ClassMethodArgsAndReturnVal, Optional<Object>> optionalConverter, Class<?> declaring, Object async, @Named(value="sync") LoadingCache<ClassMethodArgs, Object> delegateMap, Map<Class<?>, Class<?>> sync2Async, Map<String, Long> timeouts) throws SecurityException, NoSuchMethodException {
        this.optionalConverter = optionalConverter;
        this.delegateMap = delegateMap;
        this.delegate = async;
        this.declaring = declaring;
        this.sync2Async = sync2Async;
        if (!declaring.isAnnotationPresent(Timeout.class)) {
            throw new IllegalArgumentException(String.format("type %s does not specify a default @Timeout", declaring));
        }
        Timeout typeTimeout = declaring.getAnnotation(Timeout.class);
        long typeNanos = SyncProxy.convertToNanos(typeTimeout);
        this.methodMap = Maps.newHashMap();
        this.syncMethodMap = Maps.newHashMap();
        this.timeoutMap = Maps.newHashMap();
        for (Method method : declaring.getMethods()) {
            if (objectMethods.contains(method)) continue;
            Method delegatedMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            if (!Arrays.equals(delegatedMethod.getExceptionTypes(), method.getExceptionTypes())) {
                throw new IllegalArgumentException(String.format("method %s has different typed exceptions than delegated method %s", method, delegatedMethod));
            }
            if (delegatedMethod.getReturnType().isAssignableFrom(ListenableFuture.class)) {
                this.timeoutMap.put(method, this.getTimeout(method, typeNanos, timeouts));
                this.methodMap.put(method, delegatedMethod);
                continue;
            }
            this.syncMethodMap.put(method, delegatedMethod);
        }
    }

    public Class<?> getDeclaring() {
        return this.declaring;
    }

    private Long getTimeout(Method method, long typeNanos, Map<String, Long> timeouts) {
        Long timeout = this.overrideTimeout(method, timeouts);
        if (timeout == null && method.isAnnotationPresent(Timeout.class)) {
            Timeout methodTimeout = method.getAnnotation(Timeout.class);
            timeout = SyncProxy.convertToNanos(methodTimeout);
        }
        return timeout != null ? timeout : typeNanos;
    }

    static long convertToNanos(Timeout timeout) {
        long methodNanos = TimeUnit.NANOSECONDS.convert(timeout.duration(), timeout.timeUnit());
        return methodNanos;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals")) {
            return this.equals(o);
        }
        if (method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (method.isAnnotationPresent(Delegate.class)) {
            Class<?> syncClass = Optionals2.returnTypeOrTypeOfOptional(method);
            Class<?> asyncClass = this.sync2Async.get(syncClass);
            Preconditions.checkState((asyncClass != null ? 1 : 0) != 0, (Object)("please configure corresponding async class for " + syncClass + " in your RestClientModule"));
            ClassMethodArgs cma = new ClassMethodArgs(asyncClass, method, args);
            Object returnVal = this.delegateMap.get((Object)cma);
            if (Optionals2.isReturnTypeOptional(method)) {
                ClassMethodArgsAndReturnVal cmar = ((ClassMethodArgsAndReturnVal.Builder)((ClassMethodArgsAndReturnVal.Builder)ClassMethodArgsAndReturnVal.builder().fromClassMethodArgs(cma)).returnVal(returnVal)).build();
                return this.optionalConverter.apply((Object)cmar);
            }
            return returnVal;
        }
        if (this.syncMethodMap.containsKey(method)) {
            return this.syncMethodMap.get(method).invoke(this.delegate, args);
        }
        try {
            return ((ListenableFuture)this.methodMap.get(method).invoke(this.delegate, args)).get(this.timeoutMap.get(method).longValue(), TimeUnit.NANOSECONDS);
        }
        catch (ProvisionException e) {
            throw Throwables2.returnFirstExceptionIfInListOrThrowStandardExceptionOrCause(method.getExceptionTypes(), (Exception)((Object)e));
        }
        catch (ExecutionException e) {
            throw Throwables2.returnFirstExceptionIfInListOrThrowStandardExceptionOrCause(method.getExceptionTypes(), e);
        }
        catch (Exception e) {
            throw Throwables2.returnFirstExceptionIfInListOrThrowStandardExceptionOrCause(method.getExceptionTypes(), e);
        }
    }

    private Long overrideTimeout(Method method, Map<String, Long> timeouts) {
        if (timeouts == null) {
            return null;
        }
        String className = this.declaring.getSimpleName();
        Long timeout = timeouts.get(className + "." + method.getName());
        if (timeout == null) {
            timeout = timeouts.get(className);
        }
        return timeout != null ? Long.valueOf(TimeUnit.MILLISECONDS.toNanos(timeout)) : null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SyncProxy)) {
            return false;
        }
        SyncProxy other = (SyncProxy)obj;
        if (other == this) {
            return true;
        }
        if (other.declaring != this.declaring) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.declaring.hashCode();
    }

    public String toString() {
        return "Sync Proxy for: " + this.delegate.getClass().getSimpleName();
    }
}

